define([
'jQuery',
'Underscore',
'asyncSeries',
'commonFunctions'

], function($$, Underscore, asyncSeries, commonFunctions) {

module("#1129 Korean War");

//***** FUNCTIONS ******//

function openPhysicalHealthIssuesByEra() {
	// click the Physical Health Issues By Era button
	ok($( "#healthIssuesByEra" ).simulate("click"), "When I click the Physical Health Issues By Era button");
}

function isOnPhysicalHealthIssuesByEra() {
	ok($('h1:contains("Physical Health Issues By Era")' ).is(":visible"), "Physical Health Issues By Era is visible");
	ok($('h3:contains("Korean War")').is(":visible"), "Korean War button is visible");
}

function openKoreanWar() {
	// click the Korean War button
	ok($( 'h3:contains("Korean War")' ).simulate("click"), "When I click the Korean War button");
	
}

function isOnKoreanWarPage() {
	// Korean War header is visible and all buttons are visible
	ok($( 'h1:contains("Korean War   1950")' ).is(":visible"), "Korean War   1950 is visible");
	ok($( 'a:contains("Cold Injury")' ).is(":visible"), "Cold Injury button is visible");
	ok($( 'a:contains("Noise")' ).is(":visible"), "Noise button is visible");
	ok($( 'a:contains("Occupational Hazards")' ).is(":visible"), "Occupational Hazards button is visible");
	
}

function isOnCommonVeteranIssuesPage() {
	// Common Veteran Issues header is visible
	ok($( 'h1:contains("Common Veteran Issues")' ).is(":visible"), "Common Veteran Issues header is visible");
	
}



function isOnHomePage() {
	// Caring4WomenVeterans header is visible
	ok($( 'h1:contains("Caring4WomenVeterans")' ).is(":visible"), "Caring4WomenVeterans header is visible");
	ok($( 'a:contains("Common Veteran Issues")' ).is(":visible"), "Common Veteran Issues is visible");
}

function backButtonAndFooterArePresent() {
	// make sure the Back button is visible
	ok($(".ui-btn-text:contains('Back')").is(":visible"), "Back button is visible");
	
	var $footer = $("div[data-role='footer']");
	
	// make sure the footer is visible
	ok($footer.is(":visible"), "Footer is visible");
	
	// make sure all footer links are present
	ok($footer.find("a:contains('Home')").is(":visible"), "Home link is visible");
	ok($footer.find("a:contains('Search')").is(":visible"), "Search link is visible");
	ok($footer.find("a:contains('Find')").is(":visible"), "Find a VA link is visible");
	ok($footer.find("a:contains('Resources')").is(":visible"), "Resources link is visible");
}

function clickBack() {
	// click the Back button
	ok($( ".ui-btn-text:contains('Back')" ).simulate("click"), "When I click the Back button");
}

// Navigate to the Common Veteran Issues Page
function navCommonHealth() {
	// starting on main page
	ok($( "#commonHealthIssues" ).is(":visible"), "Common Veteran Issues button is visible");
	ok($( "#commonHealthIssues" ).simulate("click"), "When I click the Common Veteran Issues button");
	ok($( 'h1:contains("Common Veteran Issues")' ).is(":visible"), "Common Veteran Issues is visible");
}
test("Navigate to Health Issues By Era page and check page content", function() {
	stop();
	asyncSeries(
		isOnHomePage,
		navCommonHealth, 
		openPhysicalHealthIssuesByEra,
		isOnPhysicalHealthIssuesByEra,
		backButtonAndFooterArePresent,
		openKoreanWar,
		isOnKoreanWarPage,
		start
	);
});
test("Navigate to Cold Injury and check page content", function() {
	stop();
	asyncSeries(
		isOnHomePage,
		navCommonHealth, 
		openPhysicalHealthIssuesByEra,
		isOnPhysicalHealthIssuesByEra,
		backButtonAndFooterArePresent,
		openKoreanWar,
		isOnKoreanWarPage,
		function() {
			// go to Cold Injury page
			ok($("a:contains('Cold Injury')" ).simulate("click"), "When I click the Cold Injury button");
			//check Chemical & Biological Weapons header present
			ok($( 'h1:contains("Cold Injury")' ).is(":visible"), "Cold Injury header is visible");
			
		},
		backButtonAndFooterArePresent,
		clickBack, 
		start
	);
});
test("Navigate to Noise and check page content", function() {
	stop();
	asyncSeries(
		isOnHomePage,
		navCommonHealth, 
		openPhysicalHealthIssuesByEra,
		isOnPhysicalHealthIssuesByEra,
		backButtonAndFooterArePresent,
		openKoreanWar,
		isOnKoreanWarPage,
		function() {
			// go to Noise page
			ok($("a:contains('Noise')" ).simulate("click"), "When I click the Noise button");
			//check Noise header present
			ok($( 'h1:contains("Noise")' ).is(":visible"), "Noise header is visible");
			
		},
		backButtonAndFooterArePresent,
		clickBack, 
		start
	);
});
test("Navigate to Occupational Hazards and check page content", function() {
	stop();
	asyncSeries(
		isOnHomePage,
		navCommonHealth, 
		openPhysicalHealthIssuesByEra,
		isOnPhysicalHealthIssuesByEra,
		backButtonAndFooterArePresent,
		openKoreanWar,
		isOnKoreanWarPage,
		function() {
			// go to Occupational Hazards page
			ok($("a:contains('Occupational Hazards')" ).simulate("click"), "When I click the Occupational Hazards button");
			//check Occupational Hazards header present
			ok($( 'h1:contains("Occupational Hazards")' ).is(":visible"), "Occupational Hazards header is visible");
			
		},
		backButtonAndFooterArePresent,
		clickBack, 
		start
		);
	});
});
