define([
'jQuery',
'Underscore',
'asyncSeries',
'commonFunctions'

], function($$, Underscore, asyncSeries, commonFunctions) {

module("#1128 Cold War");

//***** FUNCTIONS ******//

function openPhysicalHealthIssuesByEra() {
	// click the Physical Health Issues By Era button
	ok($( "#healthIssuesByEra" ).simulate("click"), "When I click the Physical Health Issues By Era button");
}

function isOnPhysicalHealthIssuesByEra() {
	ok($('h1:contains("Physical Health Issues By Era")' ).is(":visible"), "Physical Health Issues By Era is visible");
	ok($('h3:contains("Cold War")').is(":visible"), "Cold War button is visible");
}

function openColdWar() {
	// click the Cold War button
	ok($( 'h3:contains("Cold War")' ).simulate("click"), "When I click the Cold War button");
	
}

function isOnColdWarPage() {
	// Cold War header is visible and all buttons are visible
	ok($( 'h1:contains("Cold War (1945 - 1991)")' ).is(":visible"), "Cold War (1945 - 1991) is visible");
	ok($( 'a:contains("Nuclear Weapons Testing (Atomic Veterans)")' ).is(":visible"), "Nuclear Weapons Testing button is visible");
	ok($( 'a:contains("Shipboard Hazards and Defense (SHAD)")' ).is(":visible"), "Shipboard Hazards and Defense button is visible");
	ok($( 'a:contains("Edgewood Arsenal")' ).is(":visible"), "Edgewood Arsenal button is visible");
	ok($( 'a:contains("Agent Orange and other Tactical Herbicides testing")' ).is(":visible"), "Agent Orange and other Tactical Herbicides testing button is visible");
	ok($( 'a:contains("Camp Lejeune Water Supplies")' ).is(":visible"), "Camp Lejeune Water Supplies button is visible");
	
}

function isOnCommonVeteranIssuesPage() {
	// Common Veteran Issues header is visible
	ok($( 'h1:contains("Common Veteran Issues")' ).is(":visible"), "Common Veteran Issues header is visible");
	
}



function isOnHomePage() {
	// Caring4WomenVeterans header is visible
	ok($( 'h1:contains("Caring4WomenVeterans")' ).is(":visible"), "Caring4WomenVeterans header is visible");
	ok($( 'a:contains("Common Veteran Issues")' ).is(":visible"), "Common Veteran Issues is visible");
}

function backButtonAndFooterArePresent() {
	// make sure the Back button is visible
	ok($(".ui-btn-text:contains('Back')").is(":visible"), "Back button is visible");
	
	var $footer = $("div[data-role='footer']");
	
	// make sure the footer is visible
	ok($footer.is(":visible"), "Footer is visible");
	
	// make sure all footer links are present
	ok($footer.find("a:contains('Home')").is(":visible"), "Home link is visible");
	ok($footer.find("a:contains('Search')").is(":visible"), "Search link is visible");
	ok($footer.find("a:contains('Find')").is(":visible"), "Find a VA link is visible");
	ok($footer.find("a:contains('Resources')").is(":visible"), "Resources link is visible");
}

function clickBack() {
	// click the Back button
	ok($( ".ui-btn-text:contains('Back')" ).simulate("click"), "When I click the Back button");
}

// Navigate to the Common Veteran Issues Page
function navCommonHealth() {
	// starting on main page
	ok($( "#commonHealthIssues" ).is(":visible"), "Common Veteran Issues button is visible");
	ok($( "#commonHealthIssues" ).simulate("click"), "When I click the Common Veteran Issues button");
	ok($( 'h1:contains("Common Veteran Issues")' ).is(":visible"), "Common Veteran Issues is visible");
}
test("Navigate to Health Issues By Era page and check page content", function() {
	stop();
	asyncSeries(
		isOnHomePage,
		navCommonHealth, 
		openPhysicalHealthIssuesByEra,
		isOnPhysicalHealthIssuesByEra,
		backButtonAndFooterArePresent,
		openColdWar,
		isOnColdWarPage,
		start
	);
});
test("Navigate to Nuclear Weapons Testing (Atomic Veterans) and check page content", function() {
	stop();
	asyncSeries(
		isOnHomePage,
		navCommonHealth, 
		openPhysicalHealthIssuesByEra,
		isOnPhysicalHealthIssuesByEra,
		backButtonAndFooterArePresent,
		openColdWar,
		isOnColdWarPage,
		function() {
			// go to Nuclear Weapons Testing page
			ok($("a:contains('Nuclear Weapons Testing (Atomic Veterans)')" ).simulate("click"), "When I click the Nuclear Weapons Testing button");
			//check Nuclear Weapons Testing header present
			ok($( 'h1:contains("Nuclear Weapons Testing (Atomic Veterans)")' ).is(":visible"), "Nuclear Weapons Testing header is visible");
			
		},
		backButtonAndFooterArePresent,
		clickBack, 
		start
	);
});
test("Navigate to Shipboard Hazards and Defense testing and check page content", function() {
	stop();
	asyncSeries(
		isOnHomePage,
		navCommonHealth, 
		openPhysicalHealthIssuesByEra,
		isOnPhysicalHealthIssuesByEra,
		backButtonAndFooterArePresent,
		openColdWar,
		isOnColdWarPage,
		function() {
			// go to Shipboard Hazards and Defense page
			ok($("a:contains('Shipboard Hazards and Defense')" ).simulate("click"), "When I click the Shipboard Hazards and Defense button");
			//check Shipboard Hazards and Defense present
			ok($( 'h1:contains("Shipboard Hazards and Defense (SHAD)")' ).is(":visible"), "Shipboard Hazards and Defense (SHAD) header is visible");
			
		},
		backButtonAndFooterArePresent,
		clickBack, 
		start
	);
});
test("Navigate to Edgewood Arsenal and check page content", function() {
	stop();
	asyncSeries(
		isOnHomePage,
		navCommonHealth, 
		openPhysicalHealthIssuesByEra,
		isOnPhysicalHealthIssuesByEra,
		backButtonAndFooterArePresent,
		openColdWar,
		isOnColdWarPage,
		function() {
			// go to Edgewood Arsenal page
			ok($("a:contains('Edgewood Arsenal')" ).simulate("click"), "When I click the Edgewood Arsenal button");
			//check Edgewood Arsenal header present
			ok($( 'h1:contains("Edgewood Arsenal")' ).is(":visible"), "Edgewood Arsenal header is visible");
			
		},
		backButtonAndFooterArePresent,
		clickBack, 
		start
		);
	});
test("Navigate to Agent Orange and other Tactical Herbicides testing and check page content", function() {
	stop();
	asyncSeries(
		isOnHomePage,
		navCommonHealth, 
		openPhysicalHealthIssuesByEra,
		isOnPhysicalHealthIssuesByEra,
		backButtonAndFooterArePresent,
		openColdWar,
		isOnColdWarPage,
		function() {
			// go to Agent Orange page
			ok($("a:contains('Agent Orange and other Tactical Herbicides testing')" ).simulate("click"), "When I click the Agent Orange button");
			//check Agent Orange  header present
			ok($( 'h1:contains("Agent Orange")' ).is(":visible"), "Agent Orange header is visible");
			
		},
		backButtonAndFooterArePresent,
		clickBack, 
		start
	);
});
test("Navigate to Camp Lejeune Water Supplies and check page content", function() {
	stop();
	asyncSeries(
		isOnHomePage,
		navCommonHealth, 
		openPhysicalHealthIssuesByEra,
		isOnPhysicalHealthIssuesByEra,
		backButtonAndFooterArePresent,
		openColdWar,
		isOnColdWarPage,
		function() {
			// go to Camp Lejeune Water Supplies page
			ok($("a:contains('Camp Lejeune Water Supplies')" ).simulate("click"), "When I click the Camp Lejeune Water Supplies button");
			//check Camp Lejeune Water Supplies header present
			ok($( 'h1:contains("Camp Lejeune Water Supplies")' ).is(":visible"), "Camp Lejeune Water Supplies header is visible");
			
		},
		backButtonAndFooterArePresent,
		clickBack, 
		start
		);
	});
});
