define([
	'jQuery',
	'Underscore',
	'asyncSeries',
	'commonFunctions'

], function($$, Underscore, asyncSeries, commonFunctions) {
	
	module("#1127 Vietnam War");
	
	//***** FUNCTIONS ******//
	
	function openPhysicalHealthIssuesByEra() {
		// click the Physical Health Issues By Era button
		ok($( "#healthIssuesByEra" ).simulate("click"), "When I click the Physical Health Issues By Era button");
	}
	
	function isOnPhysicalHealthIssuesByEra() {
		ok($('h1:contains("Physical Health Issues By Era")' ).is(":visible"), "Physical Health Issues By Era is visible");
		ok($('h3:contains("Vietnam War")').is(":visible"), "Vietnam War button is visible");
	}
	
	function openVietnamWar() {
		// click the Vietnam War button
		ok($( 'h3:contains("Vietnam War")' ).simulate("click"), "When I click the Vietnam War button");
		//ok($( "a:contains('Vietnam War')" ).simulate("click"), "When I click the Vietnam War button");
	}
	
	function isOnVietnamWarPage() {
		// Vietnam War header is visible
		ok($( 'h1:contains("Vietnam  1965")' ).is(":visible"), "Vietnam  1965- 1975 is visible");
		ok($( 'li:contains("AL Amyloidosis")' ).is(":visible"), "AL Amyloidosis is visible");
	
	}
	
	function isOnCommonVeteranIssuesPage() {
		// Common Veteran Issues header is visible
		ok($( 'h1:contains("Common Veteran Issues")' ).is(":visible"), "Common Veteran Issues header is visible");
		
	}
	
	
	
	function isOnHomePage() {
		// Caring4WomenVeterans header is visible
		ok($( 'h1:contains("Caring4WomenVeterans")' ).is(":visible"), "Caring4WomenVeterans header is visible");
		ok($( 'a:contains("Common Veteran Issues")' ).is(":visible"), "Common Veteran Issues is visible");
	}
	
	function backButtonAndFooterArePresent() {
		// make sure the Back button is visible
		ok($(".ui-btn-text:contains('Back')").is(":visible"), "Back button is visible");
		
		var $footer = $("div[data-role='footer']");
		
		// make sure the footer is visible
		ok($footer.is(":visible"), "Footer is visible");
		
		// make sure all footer links are present
		ok($footer.find("a:contains('Home')").is(":visible"), "Home link is visible");
		ok($footer.find("a:contains('Search')").is(":visible"), "Search link is visible");
		ok($footer.find("a:contains('Find')").is(":visible"), "Find a VA link is visible");
		ok($footer.find("a:contains('Resources')").is(":visible"), "Resources link is visible");
	}
	
	function clickBack() {
		// click the Back button
		ok($( ".ui-btn-text:contains('Back')" ).simulate("click"), "When I click the Back button");
	}

	// Navigate to the Common Veteran Issues Page
	function navCommonHealth() {
		// starting on main page
		ok($( "#commonHealthIssues" ).is(":visible"), "Common Veteran Issues button is visible");
		ok($( "#commonHealthIssues" ).simulate("click"), "When I click the Common Veteran Issues button");
		ok($( 'h1:contains("Common Veteran Issues")' ).is(":visible"), "Common Veteran Issues is visible");
	}
	test("Navigate to Vietnam War page and check page content", function() {
		stop();
		asyncSeries(
			isOnHomePage,
			navCommonHealth, 
			openPhysicalHealthIssuesByEra,
			isOnPhysicalHealthIssuesByEra,
			backButtonAndFooterArePresent,
			openVietnamWar,
			isOnVietnamWarPage,
			backButtonAndFooterArePresent,
			clickBack,
			isOnPhysicalHealthIssuesByEra,
			clickBack,
			isOnCommonVeteranIssuesPage,
			clickBack,
			isOnHomePage,
			start
		);
	});
});
