define([
	'jQuery',
	'Underscore',
	'asyncSeries',
	'commonFunctions'

], function($$, Underscore, asyncSeries, commonFunctions) {

	
	module("#1126 Gulf War");
	
	//***** FUNCTIONS ******//
	
	function openPhysicalHealthIssuesByEra() {
		// click the Physical Health Issues By Era button
		ok($( "#healthIssuesByEra" ).simulate("click"), "When I click the Physical Health Issues By Era button");
	}
	
	function isOnPhysicalHealthIssuesByEra() {
		ok($('h1:contains("Physical Health Issues By Era")' ).is(":visible"), "Physical Health Issues By Era is visible");
		ok($('h3:contains("Gulf War")').is(":visible"), "Gulf War button is visible");
	}
	
	function openGulfWar() {
		// click the GulfWar button
		ok($( 'h3:contains("Gulf War")' ).simulate("click"), "When I click the Gulf War button");
		
	}
	
	function isOnGulfWarPage() {
		// Gulf War header is visible and all buttons are visible
		ok($( 'h1:contains("Gulf War 1990")' ).is(":visible"), "Gulf War 1990 1991 is visible");
		ok($( 'a:contains("Chemical & Biological Weapons during the Gulf War")' ).is(":visible"), "Chemical Biological Weapons button is visible");
		ok($( 'a:contains("Depleted Uranium (DU)")' ).is(":visible"), "DU button is visible");
		ok($( 'a:contains("Burns")' ).is(":visible"), "Burn button is visible");
		ok($( 'a:contains("Immunizations & Medications")' ).is(":visible"), "Immunizations & Medications button is visible");
		ok($( 'a:contains("Infectious Diseases ")' ).is(":visible"), "Infectious Diseases  button is visible");
		ok($( 'a:contains("Oil Well Fires/Smoke")' ).is(":visible"), "Oil Well Fires/Smoke button is visible");
		ok($( 'a:contains("Heat Injury")' ).is(":visible"), "Heat Injury button is visible");
		ok($( 'a:contains("Pesticides")' ).is(":visible"), "Pesticides button is visible");
		ok($( 'a:contains("Embedded Fragments (shrapnel)")' ).is(":visible"), "Embedded Fragments button is visible");
		ok($( 'a:contains("Nerve Agents")' ).is(":visible"), "Nerve Agents button is visible");
		ok($( 'a:contains("Particulate Matter")' ).is(":visible"), "Particulate Matter button is visible");
		
	}
	
	function isOnCommonVeteranIssuesPage() {
		// Common Veteran Issues header is visible
		ok($( 'h1:contains("Common Veteran Issues")' ).is(":visible"), "Common Veteran Issues header is visible");
		
	}
	
	
	
	function isOnHomePage() {
		// Caring4WomenVeterans header is visible
		ok($( 'h1:contains("Caring4WomenVeterans")' ).is(":visible"), "Caring4WomenVeterans header is visible");
		ok($( 'a:contains("Common Veteran Issues")' ).is(":visible"), "Common Veteran Issues is visible");
	}
	
	function backButtonAndFooterArePresent() {
		// make sure the Back button is visible
		ok($(".ui-btn-text:contains('Back')").is(":visible"), "Back button is visible");
		
		var $footer = $("div[data-role='footer']");
		
		// make sure the footer is visible
		ok($footer.is(":visible"), "Footer is visible");
		
		// make sure all footer links are present
		ok($footer.find("a:contains('Home')").is(":visible"), "Home link is visible");
		ok($footer.find("a:contains('Search')").is(":visible"), "Search link is visible");
		ok($footer.find("a:contains('Find')").is(":visible"), "Find a VA link is visible");
		ok($footer.find("a:contains('Resources')").is(":visible"), "Resources link is visible");
	}
	
	function clickBack() {
		// click the Back button
		ok($( ".ui-btn-text:contains('Back')" ).simulate("click"), "When I click the Back button");
	}

	// Navigate to the Common Veteran Issues Page
	function navCommonHealth() {
		// starting on main page
		ok($( "#commonHealthIssues" ).is(":visible"), "Common Veteran Issues button is visible");
		ok($( "#commonHealthIssues" ).simulate("click"), "When I click the Common Veteran Issues button");
		ok($( 'h1:contains("Common Veteran Issues")' ).is(":visible"), "Common Veteran Issues is visible");
	}
	test("Navigate to Health Issues By Era page and check page content", function() {
		stop();
		asyncSeries(
			isOnHomePage,
			navCommonHealth, 
			openPhysicalHealthIssuesByEra,
			isOnPhysicalHealthIssuesByEra,
			backButtonAndFooterArePresent,
			openGulfWar,
			isOnGulfWarPage,
			start
		);
	});
	test("Navigate to Chemical & Biological Weapons and check page content", function() {
		stop();
		asyncSeries(
			isOnHomePage,
			navCommonHealth, 
			openPhysicalHealthIssuesByEra,
			isOnPhysicalHealthIssuesByEra,
			backButtonAndFooterArePresent,
			openGulfWar,
			isOnGulfWarPage,
			function() {
				// go to Chemical & Biological Weapons page
				ok($("a:contains('Chemical & Biological Weapons during the Gulf War')" ).simulate("click"), "When I click the Chemical & Biological Weapons button");
				//check Chemical & Biological Weapons header present
				ok($( 'h1:contains("Chemical & Biological Weapons during the Gulf War")' ).is(":visible"), "Chemical & Biological Weapons header is visible");
				
			},
			backButtonAndFooterArePresent,
			clickBack, 
			start
		);
	});
	
	test("Navigate to Depleted Uranium and check page content", function() {
		stop();
		asyncSeries(
			isOnHomePage,
			navCommonHealth, 
			openPhysicalHealthIssuesByEra,
			isOnPhysicalHealthIssuesByEra,
			backButtonAndFooterArePresent,
			openGulfWar,
			isOnGulfWarPage,
			function() {
				// go to Depleted Uranium page
				ok($("a:contains('Depleted Uranium')" ).simulate("click"), "When I click the Depleted Uranium button");
				//check Depleted Uranium header present
				ok($( 'h1:contains("Depleted Uranium")' ).is(":visible"), "Depleted Uranium header is visible");
				
			},
			backButtonAndFooterArePresent,
			clickBack, 
			start
		);
	});
	test("Navigate to Burn and check page content", function() {
		stop();
		asyncSeries(
			isOnHomePage,
			navCommonHealth, 
			openPhysicalHealthIssuesByEra,
			isOnPhysicalHealthIssuesByEra,
			backButtonAndFooterArePresent,
			openGulfWar,
			isOnGulfWarPage,
			function() {
				// go to Burn page
				ok($("a:contains('Burns')" ).simulate("click"), "When I click the Burn button");
				//check Burn header present
				ok($( 'h1:contains("Burns")' ).is(":visible"), "Burn header is visible");
				
			},
			backButtonAndFooterArePresent,
			clickBack, 
			start
		);
	});
	test("Navigate to Immunizations & Medications and check page content", function() {
		stop();
		asyncSeries(
			isOnHomePage,
			navCommonHealth, 
			openPhysicalHealthIssuesByEra,
			isOnPhysicalHealthIssuesByEra,
			backButtonAndFooterArePresent,
			openGulfWar,
			isOnGulfWarPage,
			function() {
				// go to Immunizations & Medications page
				ok($("a:contains('Immunizations & Medications')" ).simulate("click"), "When I click the Immunizations & Medications button");
				//check Immunizations & Medications header present
				ok($( 'h1:contains("Immunizations & Medications")' ).is(":visible"), "Immunizations & Medications header is visible");
				
			},
			backButtonAndFooterArePresent,
			clickBack, 
			start
		);
	});
	test("Navigate to Infectious Diseases and check page content", function() {
		stop();
		asyncSeries(
			isOnHomePage,
			navCommonHealth, 
			openPhysicalHealthIssuesByEra,
			isOnPhysicalHealthIssuesByEra,
			backButtonAndFooterArePresent,
			openGulfWar,
			isOnGulfWarPage,
			function() {
				// go to Infectious Diseases page
				ok($("a:contains('Infectious Diseases')" ).simulate("click"), "When I click the Infectious Diseases button");
				//check Infectious Diseases header present
				ok($( 'h1:contains("Infectious Diseases")' ).is(":visible"), "Infectious Diseases header is visible");
				
			},
			backButtonAndFooterArePresent,
			clickBack, 
			start
		);
	});
	test("Navigate to Oil Well Fires/Smoke and check page content", function() {
		stop();
		asyncSeries(
			isOnHomePage,
			navCommonHealth, 
			openPhysicalHealthIssuesByEra,
			isOnPhysicalHealthIssuesByEra,
			backButtonAndFooterArePresent,
			openGulfWar,
			isOnGulfWarPage,
			function() {
				// go to Oil Well Fires/Smoke page
				ok($("a:contains('Oil Well Fires/Smoke')" ).simulate("click"), "When I click the Oil Well Fires/Smoke button");
				//check Oil Well Fires/Smoke header present
				ok($( 'h1:contains("Oil Well Fires/Smoke")' ).is(":visible"), "Oil Well Fires/Smoke header is visible");
				
			},
			backButtonAndFooterArePresent,
			clickBack, 
			start
		);
	});
	test("Navigate to Heat Injury and check page content", function() {
		stop();
		asyncSeries(
			isOnHomePage,
			navCommonHealth, 
			openPhysicalHealthIssuesByEra,
			isOnPhysicalHealthIssuesByEra,
			backButtonAndFooterArePresent,
			openGulfWar,
			isOnGulfWarPage,
			function() {
				// go to Heat Injury page
				ok($("a:contains('Heat Injury')" ).simulate("click"), "When I click the Heat Injury button");
				//check Heat Injury header present
				ok($( 'h1:contains("Heat Injury")' ).is(":visible"), "Heat Injury header is visible");
				
			},
			backButtonAndFooterArePresent,
			clickBack, 
			start
		);
	});
	test("Navigate to Pesticides and check page content", function() {
		stop();
		asyncSeries(
			isOnHomePage,
			navCommonHealth, 
			openPhysicalHealthIssuesByEra,
			isOnPhysicalHealthIssuesByEra,
			backButtonAndFooterArePresent,
			openGulfWar,
			isOnGulfWarPage,
			function() {
				// go to Pesticides page
				ok($("a:contains('Pesticides')" ).simulate("click"), "When I click the Pesticides button");
				//check Pesticides header present
				ok($( 'h1:contains("Pesticides")' ).is(":visible"), "Pesticides header is visible");
				
			},
			backButtonAndFooterArePresent,
			clickBack, 
			start
		);
	});
	test("Navigate to Embedded Fragments (shrapnel) and check page content", function() {
		stop();
		asyncSeries(
			isOnHomePage,
			navCommonHealth, 
			openPhysicalHealthIssuesByEra,
			isOnPhysicalHealthIssuesByEra,
			backButtonAndFooterArePresent,
			openGulfWar,
			isOnGulfWarPage,
			function() {
				// go to Embedded Fragments page
				ok($("a:contains('Embedded Fragments (shrapnel)')" ).simulate("click"), "When I click the Embedded Fragments (shrapnel) button");
				//check Embedded Fragments header present
				ok($( 'h1:contains("Embedded Fragments")' ).is(":visible"), "Embedded Fragments header is visible");
				
			},
			backButtonAndFooterArePresent,
			clickBack, 
			start
		);
	});
	test("Navigate to Nerve Agents and check page content", function() {
		stop();
		asyncSeries(
			isOnHomePage,
			navCommonHealth, 
			openPhysicalHealthIssuesByEra,
			isOnPhysicalHealthIssuesByEra,
			backButtonAndFooterArePresent,
			openGulfWar,
			isOnGulfWarPage,
			function() {
				// go to Nerve Agents page
				ok($("a:contains('Nerve Agents')" ).simulate("click"), "When I click the Nerve Agents button");
				//check Nerve Agents header present
				ok($( 'h1:contains("Nerve Agents")' ).is(":visible"), "Nerve Agents header is visible");
				
			},
			backButtonAndFooterArePresent,
			clickBack, 
			start
		);
	});
	test("Navigate to Particulate Matter and check page content", function() {
		stop();
		asyncSeries(
			isOnHomePage,
			navCommonHealth, 
			openPhysicalHealthIssuesByEra,
			isOnPhysicalHealthIssuesByEra,
			backButtonAndFooterArePresent,
			openGulfWar,
			isOnGulfWarPage,
			function() {
				// go to Particulate Matter page
				ok($("a:contains('Particulate Matter')" ).simulate("click"), "When I click the Particulate Matter button");
				//check Particulate Matter header present
				ok($( 'h1:contains("Particulate Matter")' ).is(":visible"), "Particulate Matter header is visible");
				
			},
			backButtonAndFooterArePresent,
			clickBack, 
			start
		);
	});
});
