define([
	'jQuery',
	'Underscore',
	'asyncSeries'
], function($$, Underscore, asyncSeries) {
		//***** FUNCTIONS ******//
		
		//***** TESTS *****//
		module("#39584 Appointments Button");
		
		test("Appointments button in Booked AR Details", function() {
			var bookedRequests;
			
			stop();
			
			asyncSeries(function(){
				ok($("#list").is(":visible"),
				"Given I am on the Requests List page");
				
				return 1000;
			}, function(){
				bookedRequests = $("#appointment-request-list a[data-status='Booked']");
				
				ok(bookedRequests.eq(0).is(":visible"), "There is at least one booked request");
			}, function(){
				ok(bookedRequests.eq(0).mousedown().click(),
					"When I click a Booked appointment");
			}, function() {

				ok($("#appointment-request-details").is(":visible"),
					"Then I can see its Details page");
				
				ok($("#appointment-request-details-content .ui-btn-text:contains('Appointments')").is(":visible"),
					"Then I can see the Appointments button, since it's a Booked Appointment");
				
				ok($("#appointment-request-details-content .ui-btn-text:contains('Appointments')").mousedown().click(),
					"When I hit the Appointments button");

			}, function() {

				ok($("#schedule-list").is(":visible"),
					"Then the Appointments List page is visible");

				ok($("#request-list-btn").mousedown().click(),
					"When I click the Requests button");

			}, function() {

				ok($("#list").is(":visible"),
					"Then the Requests List page is visible");

			}, start);
		});

		test("Appointments button NOT in other AR Details", function() {
			stop();
			var otherThanBookedRequests;
			
			asyncSeries(function(){
				ok($("#list").is(":visible"),
				"Given I am on the Requests List page");
				
				return 1000;
			}, function(){
				otherThanBookedRequests = $("#appointment-request-list a[data-status='Not Booked']");
				if (otherThanBookedRequests.eq(0).is(":visible")) {
					ok(true, "There is at least one other than booked request - Found Not Booked");
				} else if ($("#appointment-request-list a[data-status='Submitted']").eq(0).is(":visible")) {
					otherThanBookedRequests = $("#appointment-request-list a[data-status='Submitted']");
					ok(true, "There is at least one other than booked request - Found Submitted");
				} else if ($("#appointment-request-list a[data-status='Cancelled']").eq(0).is(":visible")) {
					otherThanBookedRequests = $("#appointment-request-list a[data-status='Cancelled']"); 
					ok(true, "There is at least one other than booked request - Found Cancelled");
				} else {
					otherThanBookedRequests = $("#appointment-request-list a[data-status='Cancelled']");
					ok(false, "There is at least one other than booked request");	
				}
			}, function(){
				ok(otherThanBookedRequests.eq(0).mousedown().click(),
					"When I click a Booked appointment");
			}, function(){
				ok(otherThanBookedRequests.eq(0).mousedown().click(),
					"When I click an Other-Than-Booked appointment");
			}, function() {

				// REQUEST DETAILS
				ok($("#appointment-request-details").is(":visible"),
					"Then I can see its Details page");


				equal($("#appointment-request-details-content .ui-btn-text:contains('Appointments')").length, 0,
					"Then I can NOT see the Appointments button, since it's NOT a Booked Appointment");


				ok($("#appointment-request-details a[data-rel='back']").mousedown().click(),
					"When I hit the Back button");

			}, function() {
				// REQUESTS LIST
				ok($("#list").is(":visible"),
							"Then I can see the Requests List page");

			}, start);
		});

//		---------------------------------------------------------------------
});
