define([
    'jQuery',
    'Underscore',
    'asyncSeries'
], function($$, Underscore, asyncSeries) {
    //***** FUNCTIONS ******//


    module("#526/1199-Sorting appointment requests - Vet");

    test("#1509 - check for icon, check for icon title attribute, check for sort order", function() {
        asyncSeries(function(){
            if ($('#list').is(':visible')) {
                ok($("#list").is(":visible"),
                    "Given I am on the Requests List page");
            }
            return 1000;

            //Validate the new notification preference section

        }, function() {
            var titleMsg = "New Unread Message(s)";
            ok($('.new-message').length>0, true,
                'Then the New Message Indicator shows');

            ok($('.new-message').prop('title'), titleMsg,
                'Then the New Message Indicator has a title attribute and it reads: "'+titleMsg+'"');

            //Check Sort Order
            ok($('#appointment-request-list li:first .new-message').length, 1,
                'Then the New Message Indicator shows at the top');
        });
    });

    module("#526/542 - User can see that a message has been added/changed for an Appointment Request");

    test("#1510 - Validate that a new message exists for an Appointment Request", function() {
        asyncSeries(function(){
            if ($('#list').is(':visible')) {
                ok($("#list").is(":visible"),
                    "Given I am on the Requests List page");
            }
            return 1000;
        }, function() {
            var titleMsg = "New Unread Message(s)";
            //Validate the new message icon display and the order of requests
            //1st row - Mental Health appointment in submitted state with new message
            ok($("#appointment-request-list li:nth-child(1):contains('Mental Health')").text(),
                "Mental Health appointment");
            ok($("#appointment-request-list li:nth-child(1):contains('Submitted')").text(),
                "Appointment in submitted status");
            //New message icon exists
            equal($('#appointment-request-list i:nth-child(1).fonticon.chat.new-message').is(':visible'),true,
                "New message icon exists");
            //Validate Title for new message icon
            ok($('.new-message').prop('title'), titleMsg,
                'Then the New Message Indicator has a title attribute and it reads: "'+titleMsg+'"');

            //Check Sort Order
            equal($('#appointment-request-list li:first .new-message').length >0,'1',
                'Then the New Message Indicator shows at the top');

            //2nd row - Mental Health appointment in Cancelled State with no new message
            ok($("#appointment-request-list li:nth-child(2):contains('Mental Health')").text(),
                "Mental Health appointment");
            ok($("#appointment-request-list li:nth-child(2):contains('Cancelled')").text(),
                "Appointment in Cancelled status");
            //New message icon does not exist
            equal($('#appointment-request-list li:nth-child(3)').contents(':not(.new-message)').length > 0,'1',
                "New message icon does not exist");

            //3rd row - Primary Care appointment in Not Booked State with no new message
            ok($("#appointment-request-list li:nth-child(3):contains('Primary Care')").text(),
                "Primary Care appointment");
            ok($("#appointment-request-list li:nth-child(3):contains('Not Booked')").text(),
                "Appointment in Not booked status");
            //New message icon exists
            equal($('#appointment-request-list li:nth-child(3)').contents(':not(.new-message)').length > 0,'1',
                "New message icon does not exist");

            //4th row - Primary Care appointment in Booked State with no new message
            ok($("#appointment-request-list li:nth-child(4):contains('Primary Care')").text(),
                "Primary Care appointment");
            ok($("#appointment-request-list li:nth-child(4):contains('Booked')").text(),
                "Appointment in Booked status");
            //New message icon does not exist
            equal($('#appointment-request-list li:nth-child(4)').contents(':not(.new-message)').length > 0,'1',
                "New message icon does not exist");
            
          //5th row - Primary Care appointment in Submitted State with no new message
            ok($("#appointment-request-list li:nth-child(5):contains('Primary Care')").text(),
                "Primary Care appointment");
            ok($("#appointment-request-list li:nth-child(5):contains('Submitted')").text(),
                "Appointment in Submitted status");
            //New message icon does not exist
            equal($('#appointment-request-list li:nth-child(5)').contents(':not(.new-message)').length > 0,'1',
                "New message icon does not exist");
        });
    });
});