define([
	'jQuery',
	'Underscore',
	'asyncSeries'
], function($$, Underscore, asyncSeries) {
		//***** FUNCTIONS ******//
		


		//***** TESTS *****//
		module("#524-Validate Notification Preference.");

		test("#524Notification Preference Validation on new AR", function() {
			asyncSeries(function() {
			}, function() {
				$('#new-request-btn').trigger('tap');
			}, function() {
				$('#dismiss-notice-btn').trigger('click');
				
			//Validate the new notification preference section
				
			}, function() {
					ok($('#request-form-content').is(':visible'),
					'Then the New Request form is visible');
					
				//Validate the Defaults on Notification Preferences Section
					
					//Notification Pref title
					$("#request-form-form h3:contains('Notification Preferences')").text();
					ok($("#request-form-form h3:contains('Notification Preferences')").text(),
							"Notification Preference title exists in the New AR form");
					
					//Change Button label validation
					$("#change-notification-preference:contains('Change')").text();
					ok($("#change-notification-preference:contains('Change')").text(),
							"Button Name is Change");
					
					//Default Preference displayed as Text
					$("#notification-preferences-status li:contains('Text Messaging Allowed')").text();
					ok($("#notification-preferences-status li:contains('Text Messaging Allowed')").text(),
							"Text Messaging Allowed is field name and No is field value");
					$("#notification-preferences-status li:contains('Email Messaging Allowed')").text();
					ok($("#notification-preferences-status li:contains('Email Messaging Allowed')").text(),
							"Email Messaging Allowed is field name and No is field value");
					$("#notification-preferences-status li:contains('Notification Frequency')").text();
					ok($("#notification-preferences-status li:contains('Notification Frequency')").text(),
							"Notification Frequency is field name and Daily is field value");
					
				//Click Change to change notification preferences
					$("#change-notification-preference").simulate('click');
					ok($("#notification-preferences-form-content").is(':visible'),
					'Notification Preference Page');
					
				//Validate the contents of Notification Preference section
					$("#notification-preferences h1:contains('Notification Preferences')").text();
					ok($("#notification-preferences h1:contains('Notification Preferences')").text(),
							'Notification Preference Pop up window title');
					
					//Text Optional is seen on the Page, one for Email Preference and the other for Messaging Preference
					$("#notification-preferences-form-content i:contains('Optional')").text();
					ok($("#notification-preferences-form-content i:contains('Optional')").text(),
							'Optional for Messaging and Optional for Email');
					
					//Field label for Email and Text messaging
					$("#notification-preferences-form-content div:nth-child(1):contains('Are you willing to receive text messages from VA?')").text();
					ok($("#notification-preferences-form-content div:nth-child(1):contains('Are you willing to receive text messages from VA?')").text(),
							'Text messaging field label');
					$("#notification-preferences-form-content div:nth-child(1):contains('Are you willing to receive email messages from VA?')").text();
					ok($("#notification-preferences-form-content div:nth-child(1):contains('Are you willing to receive email messages from VA?')").text(),
							'Text messaging field label');
					
					//Validate if No/Yes is selected for Text messaging
					$("#prohibitTextMessaging").is(':checked');
					ok($("#prohibitTextMessaging").val(),'true',
							'Validate that No is selected for Text Messaging');
					$("#authorizeTextMessaging").is(':checked');
					ok($("#authorizeTextMessaging").val(),'false',
							'Validate that Yes is not selected for Text Messaging');
					
					//Validate if No/Yes is selected for Email messaging
					$("#prohibitEmailMessaging").is(':checked');
					ok($("#prohibitEmailMessaging").val(),'true',
							'Validate that No is selected for Text Messaging');
					$("#authorizeEmailMessaging").is(':checked');
					ok($("#authorizeEmailMessaging").val(),'false',
							'Validate that Yes is not selected for Text Messaging');
					
					//Validate Frequency Field and drop down values
					$("#notificationFrequencyOptions :contains('Notification frequency')").text();
					ok($("#notificationFrequencyOptions :contains('Notification frequency')").text(),
							'Notification frequency drop down field label');
					ok($("#notificationFrequencyOptions .ui-btn-text:contains('Daily')").is(":visible"),
						"Value Daily is the current Notification Frequency selected");
					$("#notificationFrequency :contains('Daily')").text();
					ok($("#notificationFrequency :contains('Daily')").text(),
							'Value Daily in the drop down');
					$("#notificationFrequency :contains('Never')").text();
					ok($("#notificationFrequency :contains('Never')").text(),
							'Value Never in the drop down');
					$("#notificationFrequency :contains('Each new message/status change')").text();
					ok($("#notificationFrequency :contains('Each new message/status change')").text(),
							'Value Each new message in the drop down');
					$("#cancel-request").trigger('click');
					ok($( "#list" ).is(":visible"),
					"Given I am on the Requests List page");
			});	
			
		});
		
			test("#524-Validate invalid Phone# and invalid email under notification preference", function() {
				asyncSeries(function() {
				}, function() {
					$('#new-request-btn').trigger('tap');
				}, function() {
                    if ($('#dismiss-notice-btn').is(':visible')) {
                        ok($('#dismiss-notice-btn').simulate('click'),
                            "And I get past the Notice ok button if it is there");
                    }
				}, function() {
					ok($('#request-form-content').is(':visible'),
					'Then the New Request form is visible');
					
					ok($("#request-form-form h3:contains('Notification Preferences')").text(),
							"Notification Preference title exists in the New AR form");
					
					//Click Change to change notification preference
					
					$("#change-notification-preference").simulate('click');
					ok($("#notification-preferences-form-content").is(':visible'),
					'Notification Preference Page');
				
					//Change Text Messaging from No to Yes
					$("#authorizeTextMessaging").val('Yes').trigger('click');
					$("#authorizeTextMessaging").val('Yes').trigger('click');
					$("#authorizeTextMessaging").is(':checked');
					ok($("#authorizeTextMessaging").val(),'true',
							'Validate that Yes is selected for Text Messaging');
					//Last saved value for phone number
					equal($("#textMessagingPhoneNumber").val(),'(703).789.0001 x123','Last Saved Phone Value');
				
					//Validate Phone number with alphanumeric charac and special charac
					$("#textMessagingPhoneNumber").val('(703).ABCD%$.890_9000');
					ok($('#textMessagingPhoneNumber').val(), '(703).ABCD%$.890_9000',
						'invalid phone number is entered');
				
					$("#submit-notification-preferences").trigger('click');
					ok($("#notification-preferences-error :contains('Phone must have a minimum of 10 digits and only contain digits and these characters: + ( ) - . x space')"),
						'2nd time Validation message for invalid phone number');
				
					//Enter invalid email content
					$("#authorizeEmailMessaging").val('Yes').trigger('click');
					$("#authorizeEmailMessaging").val('Yes').trigger('click');
					ok($("#authorizeEmailMessaging").val(),'true',
						'Validate that Yes is selected for Email Messaging');
					//Last saved value for phone number
					//Updated to include hyphen in email address for defect MDPD#1578
					equal($("#messagingEmailAddress").val(),'PATID76@test-ing.com','Last Saved Email Value');
					
					$("#messagingEmailAddress").val('test$123,com');
					equal($('#messagingEmailAddress').val(), 'test$123,com',
						'invalid email address is entered');
					
					//Validate error message on submit
					$("#submit-notification-preferences").trigger('click');
					ok($("#notification-preferences-error :contains('Email must be between 3 and 50 characters in a valid email format')"),
						'Validation message for invalid email');
					
					//Cancel out of Notification Preference modal
					ok($("#notification-preferences-form-content").is(':visible'),
					'Notification Preference Page');
					$("#cancel-notification-preferences").trigger('click');
					$("#cancel-request").trigger('click');
					
					//Return to appointment request list page
					ok($('#list').is(':visible'),
					'Then the New Request form is visible');
					
			});
		});

//		---------------------------------------------------------------------
});

		


