define([
	'jQuery',
	'Underscore',
	'asyncSeries'
], function($$, Underscore, asyncSeries) {

		//***** FUNCTIONS ******//
		function selectTypeOfCare (careType) {
			// Given Primary Care is selected
			var targetRadio,
				targetRadioFound = false;
			$.each($('input[name=appointmentType]'), function(index, currentType) { 
				if (currentType.value == careType) {
					targetRadioFound = true;
					targetRadio = $(currentType);
					return;
				}
			});
			ok(targetRadioFound, careType + ' radio button found');
			if (targetRadioFound) {
				ok(targetRadio.is(":visible"), 
					careType + ' radio button is visible');
				ok(targetRadio.simulate('click'),
					"When I click the " + careType + " radio button");
			}
		}

		function ensurePhoneCallNotSelected () {
			$.each($('input[name=visitType]'), function(index, currentType) { 

				if (currentType.value != 'Phone Call') {

					ok($(currentType).simulate('click'),
						"When I try to click a Type of Visit other than 'Phone Call'");

					ok($('input[name=visitType]:checked').val() == "Office Visit" || $('input[name=visitType]:checked').val() == "Video Conference",
						"Then I am able to do so");

					return false;
				}
			});
		}

		function changePurposeOfVisit (visitPurpose) {

			var validPurpose = false;
			var purposeOfVisitOptions = $("#purposeOfVisit option");
			ok(purposeOfVisitOptions.length > 0, "Purpose of visit options exist");
			
			$.each(purposeOfVisitOptions, function(index){
				if ($(this).val() === visitPurpose) {
					validPurpose = true;
					return false;
				}
			});
			
			ok(validPurpose, visitPurpose + " is a valid purpose of visit");

			ok($("#purposeOfVisit").val(visitPurpose).change(),
				"When I change Purpose of Visit to " + visitPurpose);

		}

		function closeRequestForm () {
			asyncSeries(function() {
				ok($("#cancel-request").simulate("click"),
					"When I click the Cancel button");
			},
			function(){
				ok($( "#list" ).is(":visible"),
				"Then I am on the Requests List page");

			});

			return 1000;

		}

		//***** TESTS *****//
		module("#38717 Type of Care ");

		test('Primary Care selected', function() {
			stop();
			asyncSeries(function() {

				ok($('#list').is(':visible'),
					'Given I am on the Requests List page');

				ok($('#request-form-content').is(':not(:visible)'),
					'Then the New Request form not visible');

				ok($('#new-request-btn').trigger('tap'),
					"When I tap on the New Request button");

			}, function() {

				if ($('#dismiss-notice-btn').is(':visible')) {
					ok($('#dismiss-notice-btn').simulate('click'),
						"And I get past the Notice ok button if it is there");
				}

			}, function() {

				ok($('#request-form-content').is(':visible'),
					'Then the New Request form is visible');

			}, function() {

				selectTypeOfCare('Primary Care');				

			}, function() {

				equal($('#purposeOfVisit').val(), "Select",
				"And no Purpose of Visit is selected");

				equal($('input[name=visitType]:checked').length, 0,
					'Then Visit type remains unchecked');

				changePurposeOfVisit('Routine follow-up');

				equal($('input[name=visitType]:checked').length, 0,
					'Then Visit type remains unchecked');

				changePurposeOfVisit('New issue');

				equal($('input[name=visitType]:checked').length, 0,
					'Then Visit type remains unchecked');

				changePurposeOfVisit('Other');

				equal($('input[name=visitType]:checked').length, 0,
					"Then Visit type remains unchecked");

				changePurposeOfVisit('Medication concern');

				equal($('input[name=visitType]:checked').length, 1,
					'Then only 1 visit type is checked');

				ok($('input[name=visitType]:checked').val() == "Phone Call",
					'And the selected visit type is Phone Call');

				ensurePhoneCallNotSelected();

				changePurposeOfVisit('Medication concern');

				equal($('input[name=visitType]:checked').length, 1,
					'Then only 1 visit type is checked');

				ok($('input[name=visitType]:checked').val() == "Phone Call",
					'And the selected visit type is Phone Call');

			}, closeRequestForm, start);

		});

		test("Mental Health selected", function() {
			stop();
			asyncSeries(function() {

				ok($('#list').is(':visible'),
					'Given I am on the Requests List page');

				ok($('#request-form-content').is(':not(:visible)'),
					'Then the New Request form not visible');

				ok($('#new-request-btn').trigger('tap'),
					"When I tap on the New Request button");

			}, function() {

				if ($('#dismiss-notice-btn').is(':visible')) {
					ok($('#dismiss-notice-btn').simulate('click'),
						"And I get past the Notice ok button if it is there");
				}

			}, function() {

				ok($('#request-form-content').is(':visible'),
					'Then the New Request form is visible');				

			}, function() {

				selectTypeOfCare('Mental Health');

			}, function() {

				var purposeOfVisit = $('#purposeOfVisit');

				changePurposeOfVisit('Medication concern');

				equal($('input[name=visitType]:checked').length, 0,
					'Then Visit type remains unchecked');

				ensurePhoneCallNotSelected();

				var selectedVisitType = $('input[name=visitType]:checked').val();

				changePurposeOfVisit('Medication concern');

				equal($('input[name=visitType]:checked').val(), selectedVisitType,
					'Then Visit Type did not change');

			}, closeRequestForm, start);

		});

//		---------------------------------------------------------------------		
	
});