define([
	'jQuery',
	'Underscore',
	'asyncSeries'
], function($$, Underscore, asyncSeries) {
		//***** FUNCTIONS ******//
		
		function openAbout() {
			// When I can click the About button
			ok($( "div[data-role='navbar'] a[href='#about']" ).simulate("click"),
			"When I click the About button");
		}

		function clickOk() {
			ok($( "#about-ok-btn" ).simulate('click'),
			"When I click the OK button");
		}

		function clickClose() {
			ok($( "#about a[title='Close']" ).simulate('click'),
			"When I click the Close button");
		}

		//***** TESTS *****//
		module("#38511 Requests List");

		test("Requests List", function() {
			stop();
			asyncSeries(function() {
			// Given I am on the Request List page
			ok($( "#list" ).is(":visible"),
				"Given I am on the Requests List page");

			// Then I can see the About button
			ok($( "div[data-role='navbar'] a[href='#about']" ).is(":visible"),
				"Then I can see the About button");
			}, start);

		});

		test("Requests List -> About: Layout", function() {
			stop();
			asyncSeries(openAbout, function() {

				// Then I am on the About dialog
				ok($( "#about" ).is(":visible"),
					"Then I am on the About dialog");


				// Then I can see the About header
				ok($( "#about h1" ).is(":visible"),
					"Then I can see the About header");


				//Then I can see Intended Users paragraph
				ok($( "#about h3:contains('Intended Users')").is(":visible"),
					"Then I can see the Intended Users header");

				equal($( "#about h3:contains('Intended Users') + p").text(), 
					"This app is intended for use by Veterans who have an established healthcare relationship with the Department of Veteran Affairs.  Individuals without such a relationship will not be able to create a request for an appointment.  Additionally, a veteran can only submit a request for an appointment at a facility where they have been registered or have received care.  If you try to submit a request for a facility that does not have current registration information, you will be directed to information where you can register for that facility.",
					"Then I can see the Intended Users paragraph");
				
				//Then I can see info on Phone Calls
				ok($( "#about h3:contains('Your Phone Number and Calls from the Department of Veteran Affairs')" ).is(":visible"),
					"Then I can see Phone Calls header");

				equal($( "#about h3:contains('Your Phone Number and Calls from the Department of Veteran Affairs') + p" ).text(),
					"Your phone number and best times for the Department of Veteran Affairs to call you are being requested in case clarification about an appointment request is needed.  Your information will not be shared.  Typically there will be no need to call about an appointment request except if the clerk is unable to book a 2nd request.  If there is a need to call, the clerk will attempt to call during the times you have provided.",
					"Then I can see the Phone Calls paragraph");


				//Then I can see info on Text Messaging
				ok($("#about h3:contains('Cell Phone Number and Text Messages from the Department of Veteran Affairs')").is(":visible"),
					"Then I can see the Text Messaging header");

				equal($("#about h3:contains('Cell Phone Number and Text Messages from the Department of Veteran Affairs') + p").text(),
					"Your cell number is requested so that if your Department of Veteran Affairs facility provides text message alerts about appointments you can take advantage of this service.  Your information will not be shared.  Providing the information is optional. ",
					"Then I can see the Text Messaging paragraph");


				//Then I can see info on Video Clinic
				ok($("#about h3:contains('Video Clinic Information')").is(":visible"),
					"Then I can see the Video Clinic header");

				equal($("#about h3:contains('Video Clinic Information') + p").text(),
					"The Department of Veteran Affairs has begun to implement Video Clinics.  Not all clinics or providers currently have this capability. If the clinic/provider you request does not have Video Clinics, your request will be treated as a Telephone request.  For Video Clinics, you will need a computer (or tablet) and internet access.  You will need to download Jabber software prior to the visit.",
					"Then I can see the Video Clinic paragraph");

			
				//Then I can see info on 2nd Attempts
				ok($( "#about h3:contains('Attempt Request')" ).is(":visible"),
					"Then I can see the 2nd Attempt Request header");

				equal($( "#about h3:contains('Attempt Request') + p" ).text(),
					'If the clinic is unable to book an appointment using your first three time options, you will have seven (7) days to create a second attempt request.  To submit this type of request, you will be asked to provide two (2) additional timeframes based upon the original request.  This will create a new "2nd attempt" request in the application.  If the clinic is unable to book you an appointment based upon one of these times, a clerk will attempt to call you to discuss.',
					"Then I can see the 2nd Attempt Request paragraph");

				//Then I can see info on Notifications
				ok($( "#about h3:contains('Settings')" ).is(":visible"),
					"Then I can see Settings header");

				equal($( "#about h3:contains('Settings') + p" ).text(),
					"The notifications provided to users of this app are related to requests submitted through this app only.  The notification will alert you to the fact that the status of a request has changed.  As you open the app, requests that have changed will be at the top of the list.  Selecting one of these items will display current details about your request.  Notifications for appointments made outside of this app (in-person, telephonically, or other) are handled through separate means.",
					"Then I can see Settings paragraph");

				//Then I can see info on Definitions
				ok($( "#about h3:contains('Definitions')" ).is(':visible'),
					"Then I can see Definitions header");

				equal($( "#about li" ).eq(0).text(),
					"Submitted  Indicates the request has been sent and is pending review and action by the clinic.",
					"Then I can see Submitted Definition list item");

				equal($( "#about li" ).eq(1).text(),
					"Booked  Indicates that the Department of Veteran Affairs was able to book you an appointment based upon your request.  You can see the details of the appointment and all Department of Veteran Affairs appointments in the next 120 days in the Appointments tab.",
					"Then I can see Booked Definition list item");

				equal($( "#about li" ).eq(2).text(),
					"Not Booked  Indicates that the clinic was not able to book you an appointment based upon your request.",
					"Then I can see Not Booked Definition list item");

				equal($( "#about li" ).eq(3).text(),
					"Cancelled  This can indicate cancellations by you or the clinic.  The details view for each request will have additional information.",
					"Then I can see Cancelled Definition list item");

				// Then I can see the OK button
				ok($( "#about-ok-btn" ).is(":visible"),
					"Then I can see the OK button");

				// Then I can see the Close button
				ok($( "#about a[title='Close']" ).is(":visible"),
					"Then I can see the Close button");

			}, clickClose, start);

		});

		test("Requests List -> About: OK", function() {
			stop();
			asyncSeries(function(){

				ok($( "#list").is(":visible"),
					"Given I am on the Requests List page");

			}, openAbout, clickOk, function() {

				ok($( "#list" ),
					"Then I am on the Requests List page");

			}, start);

		});

		test("Requests List -> About: Cancel", function() {
			stop();
			asyncSeries(function() {

				ok($( "#list").is(":visible"),
					"Given I am on the Requests List page");

			}, openAbout, clickClose, function() {

				ok($( "#list" ),
					"Then I am on the Requests List page");

			}, start);

		});

		test("Appointments List -> About: OK", function() {
			stop();
			asyncSeries(function() {

				ok($( "#schedule-list-btn").simulate('click'),
					"When I click the Appointments button");				

			}, openAbout, clickOk, function() {

				ok($( "#schedule-list" ).is(":visible"),
					"Then I am on the Appointments List page");

				ok($( "#request-list-btn").simulate('click'),
					"Return to requests list");

			}, start);

		});

		test("Appointments List -> About: Cancel", function() {
			stop();
			asyncSeries(function() {

				ok($( "#schedule-list-btn").simulate('click'),
					"When I click the Appointments button");

			}, openAbout, clickClose, function() {

				ok($( "#schedule-list" ).is(":visible"),
					"Then I am on the Appointments List page");

				ok($( "#request-list-btn").simulate('click'),
					"Return to requests list");

			}, start);

		});
//		---------------------------------------------------------------------
});
