define([
	'jQuery',
	'Underscore',
	'asyncSeries'
], function($$, Underscore, asyncSeries) {
		//***** FUNCTIONS ******//
		
		function openAbout() {
			// When I can click the About button
			ok($( "div[data-role='navbar'] a[href='#about']" ).simulate("click"),
			"When I click the About button");
		}

		function clickOk() {
			ok($( "#about-ok-btn" ).simulate('click'),
			"When I click the OK button");
		}

		function clickClose() {
			ok($( "#about a[title='Close']" ).simulate('click'),
			"When I click the Close button");
		}

		//***** TESTS *****//
		module("#1196/#1197 - Additional iButton text for VAR");

		test("#1617 - Validate the content in the iButton for messaging business rules.", function() {
			stop();
			asyncSeries(openAbout, function() {
				// Then I am on the About dialog
				ok($( "#about" ).is(":visible"),
					"Then I am on the About dialog");


				// Then I can see the About header
				ok($( "#about h1" ).is(":visible"),
					"Then I can see the About header");

			}, function() {
			//Then I can see info on Additional Requests Detail Messaging
                ok($('#requestMessagingInfo').is(":visible"),
                    "Then I can see Messaging Header");

                equal($("#requestMessagingInfo li" ).eq(0).text(),
                    "Each message is limited to 100 characters.",
                    "Then I can see character limits");

                equal($("#requestMessagingInfo li" ).eq(1).text(),
                    "Maximum of 2 message exchanges per submitted request.",
                    "Then I can see max messages");

                equal($("#requestMessagingInfo li" ).eq(2).text(),
                    "After submitting a request with Additional Request Details message, you must receive a response before sending another message.",
                    "Then I can see response message");

                equal($("#requestMessagingInfo li" ).eq(3).text(),
                    "Message exchanges are for clarifying information about the specific appointment request.",
                    "Then I can see clarifying");

                equal($("#requestMessagingInfo li" ).eq(4).text(),
                    "Messages are not intended for answering clinical care questions, and there is no timeframe for responses. If you have questions regarding your healthcare, please call the clinic/facility directly.",
                    "Then I can see not clinical care");

                equal($("#requestMessagingInfo li" ).eq(5).text(),
                    "Messages cannot be initiated within 2 business days of the appointment date.",
                    "Then I can see 2 business days");

                equal($("#requestMessagingInfo li" ).eq(6).text(),
                    "Messages cannot be replied to on the day of the appointment.",
                    "Then I can see not on day of appointment");

                equal($("#requestMessagingInfo li" ).eq(7).text(),
                    "Messages cannot be sent once the appointment date has past, OR if the appointment is cancelled.",
                    "Then I can see not after appointment date/Cancelled request");


				// Then I can see the OK button
				ok($( "#about-ok-btn" ).is(":visible"),
					"Then I can see the OK button");

				// Then I can see the Close button
				ok($( "#about a[title='Close']" ).is(":visible"),
					"Then I can see the Close button");

			}, clickClose, start);

		});
//		---------------------------------------------------------------------
});
