define([
	'jQuery',
	'async',
	'common'
], function(jQuery, async, commonTests, appname, search, views ) {
	var $$ = jQuery.noConflict(true),
	myFrame = $$("#myFrame");
	
	var setup = function() {
		var referencePath = window.location.protocol + "//" + window.location.host + window.location.pathname, 
			pathArr = referencePath.split('/'),
			appPath = 'antibiogram';
		pathArr.pop();
		pathArr.pop();
		pathArr.pop();
		referencePath = pathArr.join('/') ;
		
		defineTests();

		async.series([
			function(next) {
				$$(document).ready(function() { next(); });
			},
			function(next) {
				myFrame.attr('src', referencePath + '/logout')
					.one('load', function() { next(); });
			},
			function(next) {
				myFrame.attr('src', referencePath + '/oauthlogin?redirect_uri=' + referencePath + '/'+appPath)
					.one('load', function() {
						next();
					});
			},
			function(next) {
				//grab jQuery from inside the document
				$ = jQuery = myFrame[0].contentWindow.jQuery;

				$("#name-c").val( 'zztest.staff01' );
				$("#password").val('pass');
				$("#facilityName").val('DC VAMC');
				$("#facilityCode").val('688');
				myFrame.one('load', function(e) {
					//grab jQuery from inside the document
					$ = jQuery = myFrame[0].contentWindow.jQuery;
		
					//turn off async so tests will wait for ajax results
					$.ajaxSetup({ async: false });
					$.getScript(referencePath +"/test/jquery.simulate.js");
		
					//turn off animations so they do not break tests
					$.support.cssTransitions = false;
					$.fx.off = true;
					next(); 
				});

				setTimeout( function(){
					$('#loginButton').click();
				},100);
				
			}
		], function() {
			start();
		});

		//QUnit.testStart(function() {
		//	QUnit.start();
		//});
		QUnit.testStart(function() {
			stop();
			myFrame.attr('src', referencePath + '/' +appPath)
				.on("load", function() {
					//grab jQuery from inside the document
					$ = jQuery = myFrame[0].contentWindow.jQuery;
		
					//turn off async so tests will wait for ajax results
					$.ajaxSetup({ async: false });
					$.getScript(referencePath +"/test/jquery.simulate.js");
		
					//turn off animations so they do not break tests
					$.support.cssTransitions = false;
					$.fx.off = true;
					
					QUnit.start();
				});
		});


	};

	function defineTests() {
		search.initialize();
		appname.initialize();
		views.initialize();
	}
	
	return {
		initialize: setup
	};
});
