define([
	'jQuery',
	'async',
	'common'
], function(jQuery, async, commonTests){
	var $$ = jQuery.noConflict(true),
		myFrame = $$("#myFrame"),
		setup = function(){
			var referencePath = window.location.protocol + "//" + window.location.host + window.location.pathname,
				pathArr = referencePath.split('/'),
				appPath = 'antibiogram';
			pathArr.pop();
			pathArr.pop();
			pathArr.pop();
			referencePath = pathArr.join('/');

			require(['634']); // App framework
			require(['640']); // Facility search
			require(['1074']); // Organism search
			require(['628']); // Antibiotic table

			async.series([
				function(next){
					$$(document).ready(function(){
						next();
					});
				},
				// **TO LOG IN**
				function(next){
					myFrame.attr('src', referencePath + '/logout')
						.one('load', function(){
							next();
						});
				},
				function(next){
					myFrame.attr('src', referencePath + '/oauthlogin?redirect_uri=' + referencePath + '/' + appPath)
						.one('load', function(){
							next();
						});
				},
				// **END TO LOG IN**
				// **TO NOT LOG IN**
				// function(next) {
				// myFrame.attr('src', referencePath + '/' + appPath).one('load', function() { next(); });
				// },
				// **END TO NOT LOG IN**
				function(next){
					//grab jQuery from inside the document
					$ = jQuery = myFrame[0].contentWindow.jQuery;

					// **TO LOG IN**
					$("#name-c").val('zztest.staff01');
					$("#password").val('pass');
					$('#autocomplete-container input').val('DC VAMC');
					$('#facilityName').val('DC VAMC');
					$("#facilityCode").val('688');
					// **END TO LOG IN**

					//next();
					$("#logonForm").submit();
					myFrame.one('load', function(){
						$ = jQuery = myFrame[0].contentWindow.jQuery;
						next();
					});

				}
			], function(){
				start();
			});

			//QUnit.testStart(function() {
			//	QUnit.start();
			//});

			QUnit.testStart(function(){
				stop();
				myFrame.attr('src', referencePath + '/' + appPath)
					.on("load", function(){
						//grab jQuery from inside the document
						$ = jQuery = myFrame[0].contentWindow.jQuery;

						//turn off async so tests will wait for ajax results
						$.ajaxSetup({ async: false });
						$.getScript(referencePath + "/test/jquery.simulate.js");

						//turn off animations so they do not break tests
						$.support.cssTransitions = false;
						$.fx.off = true;

						QUnit.start();
					});
			});
		};

	return {
		initialize: setup
	};
});
