define([
	'jQuery',
	'../helpers'
], function($$, helpers) {
		
	module("#640 Antibiogram Facility Search");
	
	//***** FUNCTIONS ******//
	
	function openSearchPage(next) {
		// click the Search button
		ok($( "#footer-antibiogram-search-btn" ).simulate("click"), "When I click the Search button");
		
		// best way is to listen to page load event
		setTimeout(function() {
			next();
		}, 1000);
	}
	
	function openCompletePage(next) {
		// click the Complete button
		ok($( "#footer-search-all-btn" ).simulate("click"), "When I click the Complete button");
		
		// best way is to listen to page load event
		setTimeout(function() {
			next();
		}, 1000);
	}

	//***** TESTS *****//
	
	// Acceptance Criteria MDPD-641
	test("When user is logged in and goes to Search page, facility is already selected", function() {
		stop();
		expect(6);
		async.series([function (next) {
				var $footer = $("div[data-role='footer']");
				// make sure the footer is visible
				ok($footer.is(":visible"), "Footer is visible");
				// make sure Search link is present
				ok($footer.find("#footer-antibiogram-search-btn").is(":visible"), "Search link is visible");
				next();
			},
			openSearchPage,
			function (next) {
				// make sure the "Find Facility" box is visible
				ok($("#facilityName").is(":visible"), "Find Facility box is visible");
				// since user is logged in, facility code (hidden field) is populated
				equal($("#facilityCode").val(), "688", "'688' is in the hidden field: When this fails it's because MobileHealthPlatformWeb/js/models/userSession.js is returning undefined for this.get('mhpuser')");
				// since user is logged in, box is populated (MDPD-641)
				equal($("#facilityName").val(), "DC VAMC", "'DC VAMC' is already in the box: When this fails it's because MobileHealthPlatformWeb/js/models/userSession.js is returning undefined for this.get('mhpuser')");
				next();
			}, function(next) {
				next();
			}], start);
	});
	
	// Acceptance Criteria MDPD-641
	test("When user is logged in and goes to Complete page, facility is already selected", function() {
		stop();
		expect(6);
		async.series([function (next) {
				var $footer = $("div[data-role='footer']");
				// make sure the footer is visible
				ok($footer.is(":visible"), "Footer is visible");
				// make sure Complete link is present
				ok($footer.find("#footer-search-all-btn").is(":visible"), "Complete link is visible");
				next();
			},
			openCompletePage,
			function (next) {
				// make sure the "Find Facility" box is visible
				ok($("#facilityName").is(":visible"), "Find Facility box is visible");
				// since user is logged in, facility code (hidden field) is populated
				equal($("#facilityCode").val(), "688", "'688' is in the hidden field: When this fails it's because MobileHealthPlatformWeb/js/models/userSession.js is returning undefined for this.get('mhpuser')");
				// since user is logged in, box is populated (MDPD-641)
				equal($("#facilityName").val(), "DC VAMC", "'DC VAMC' is already in the box: When this fails it's because MobileHealthPlatformWeb/js/models/userSession.js is returning undefined for this.get('mhpuser')");
				next();
			}, function(next) {
				next();
			}], start);
	});
	
	// ACCEPTANCE CRITERIA MDPD-1558
	test("When user searches for a facility on the Search page, the list of facilities comes up", function() {
		stop();
		expect(6);
		async.series([function (next) {
				var $footer = $("div[data-role='footer']");
				// make sure the footer is visible
				ok($footer.is(":visible"), "Footer is visible");
				// make sure Search link is present
				ok($footer.find("#footer-antibiogram-search-btn").is(":visible"), "Search link is visible");
				next();
			},
			openSearchPage,
			function (next) {
				// make sure the "Find Facility" box is visible
				ok($("#facilityName").is(":visible"), "Find Facility box is visible");
				// type into box
				ok($("#facilityName").val("DC").trigger("keydown"), "When I type 'DC' into the box");
				next();
			//	return 1000;
			}, function(next) {
				setTimeout(function() {
					// list appears
					ok($("ul.ui-autocomplete li.ui-menu-item:contains('DC VAMC')").is(":visible"), "'DC VAMC' is visible in list");
					next();
				}, 1000);
			}], start);
	});

	// ACCEPTANCE CRITERIA MDPD-1558
	test("When user searches for a facility on the Complete page, the list of facilities comes up", function() {
		stop();
		expect(6);
		async.series([function (next) {
				var $footer = $("div[data-role='footer']");
				// make sure the footer is visible
				ok($footer.is(":visible"), "Footer is visible");
				// make sure Search link is present
				ok($footer.find("#footer-antibiogram-search-btn").is(":visible"), "Search link is visible");
				next();
			},
			openCompletePage,
			function (next) {
				// make sure the "Find Facility" box is visible
				ok($("#facilityName").is(":visible"), "Find Facility box is visible");
				// type into box
				ok($("#facilityName").val("DC").trigger("keydown"), "When I type 'DC' into the box");
				next();
			},
			function (next) {
				setTimeout(function() {
					// list appears
					ok($("ul.ui-autocomplete li.ui-menu-item:contains('DC VAMC')").is(":visible"), "'DC VAMC' is visible in list");
					next();
				}, 1000);
			}], start);
	
	});
	
	// ACCEPTANCE CRITERIA MDPD-1559
	test("When a facility is selected, the app remembers the selection", function () {
		stop();
		expect(4);
		async.series([function (next) {
				next();
			},
			openSearchPage,
			function (next) {
				// make sure facility name is populated
				equal($("#facilityName").val(), "DC VAMC", "'DC VAMC' is in box: When this fails it's because MobileHealthPlatformWeb/js/models/userSession.js is returning undefined for this.get('mhpuser')");
				next();
			},
			openCompletePage,
			function (next) {
				// make sure facility name is still populated
				equal($("#facilityName").val(), "DC VAMC", "'DC VAMC' is still in box after switching pages: When this fails it's because MobileHealthPlatformWeb/js/models/userSession.js is returning undefined for this.get('mhpuser')");
				next();
			}], start);
	});
});
