define([
	'jQuery',
	'../helpers'
], function($$, helpers) {
	module("#634 Antibiogram App Framework");
	
	//***** FUNCTIONS ******//
	
	function clickLogInOrOut(next) {
		// click the Login/Logout button
		ok($("#footer-logout-btn").simulate("click"), "When I click the Login/Logout button");
		
		// best way is to listen to page load event
		setTimeout(function() {
			next();
		}, 1000);
	}
	
	function openSearchPage(next) {
		// click the Search button
		ok($( "#footer-antibiogram-search-btn" ).simulate("click"), "When I click the Search button");
		
		// best way is to listen to page load event
		setTimeout(function() {
			next();
		}, 1000);
	}
	
	function openCompletePage(next) {
		// click the Complete button
		ok($( "#footer-search-all-btn" ).simulate("click"), "When I click the Complete button");
		
		// best way is to listen to page load event
		setTimeout(function() {
			next();
		}, 1000);
	}
	
	function openAboutPage(next) {
		// click the About button
		ok($( "#footer-about-btn" ).simulate("click"), "When I click the About button");
		
		// best way is to listen to page load event
		setTimeout(function() {
			next();
		}, 1000);
	}

	//***** TESTS *****//
	
	// Acceptance Criteria MDPD-412, MDPD-415, MDPD-1417, MDPD-1418
	test("Landing page can be reached and contains correct elements", function() {
		stop();
		expect(8);
		async.series([function (next) {
				// Antibiogram header is visible (MDPD-415)
				ok($("h1:contains('Antibiogram')").is(":visible"), "Antibiogram header is visible");
				// Instructions content is visible (MDPD-1418)
				ok($( 'li:contains("Select Search or All")' ).is(":visible"), "Instructions content is visible");
				// URL contains "antibiogram" (MDPD-412)
				ok(window.location.pathname.indexOf("antibiogram") > -1, "URL contains application name");
				
				var $footer = $("div[data-role='footer']");
				
				// make sure the footer is visible
				ok($footer.is(":visible"), "Footer is visible");
				
				// make sure all footer links are present (MDPD-1417)
				ok($footer.find("#footer-launchpad-btn").is(":visible"), "Launchpad link is visible");
				ok($footer.find("#footer-antibiogram-search-btn").is(":visible"), "Search link is visible");
				ok($footer.find("#footer-search-all-btn").is(":visible"), "Complete link is visible");
				ok($footer.find("#footer-about-btn").is(":visible"), "About link is visible");
				next();
			}, function(next) {
				next();
			}], start);
	});
	
	// THERE IS NO AC FOR THIS - AMANDA
	//This test is failing due to QUnit async-related issues. Commenting it out at Ben's suggestion, while we continue to research this problem. Amanda
//	test("Launchpad can be reached and contains correct elements", function() {
//			stop();
//			expect(3);
//			async.series([function (next) {
//				var $footer = $("div[data-role='footer']");
//				// make sure the footer is visible
//				ok($footer.is(":visible"), "Footer is visible");
//				// make sure Launchpad link is present
//				ok($footer.find("#footer-launchpad-btn").is(":visible"), "Launchpad link is visible");
//				// click Launchpad button
//				// ok($( "#footer-launchpad-btn" ).simulate("click"), "When I click the Launchpad button");
//				next();
//			},
//			function (next) {
//					setTimeout(function() {
//						// Launchpad header is visible
//						ok($("h1:contains('Launchpad')").is(":visible"), "Launchpad header is visible");
//						next();
//					}, 3000);
//				}], start);
//	});
	
	// Acceptance Criteria: MDPD-648
	// NOTE: While this problem (described above) persists, we are also unable to test (via QUnit) the ability to access the app without logging in.
	
	// Acceptance Criteria MDPD-1419, MDPD-1421, MDPD-1424, MDPD-1417
	test("Organism (Search) page can be reached and contains correct elements", function() {
		stop();
		expect(11);
		async.series([function (next) {
				var $footer = $("div[data-role='footer']");
				// make sure the footer is visible
				ok($footer.is(":visible"), "Footer is visible");
				// make sure Search link is present
				ok($footer.find("#footer-antibiogram-search-btn").is(":visible"), "Search link is visible");
				next();
			},
			openSearchPage,
			function (next) {
				// make sure the "Find Facility" box is visible (MDPD-1419)
				ok($("#facilityName").is(":visible"), "Find Facility box is visible");
				// make sure the Data Range selector is visible (MDPD-1421)
				ok($("#select-date-range").is(":visible"), "Data Range selector is visible");
				// make sure the "Search Organisms" box is visible (MDPD-1424)
				ok($("#organismName").is(":visible"), "Search Organisms box is visible");
				
				var $footer = $("div[data-role='footer']");
				
				// make sure the footer is visible
				ok($footer.is(":visible"), "Footer is visible");
				
				// make sure all footer links are present (MDPD-1417)
				ok($footer.find("#footer-launchpad-btn").is(":visible"), "Launchpad link is visible");
				ok($footer.find("#footer-antibiogram-search-btn").is(":visible"), "Search link is visible");
				ok($footer.find("#footer-search-all-btn").is(":visible"), "Complete link is visible");
				ok($footer.find("#footer-about-btn").is(":visible"), "About link is visible");
				next();
			}, function(next) {
				next();
			}], start);
	});
	
	// Acceptance Criteria MDPD-1420, MDPD-1422, MDPD-1417
	test("Facility (Complete) page can be reached and contains correct elements", function() {
		stop();
		expect(11);
		async.series([function (next) {
				var $footer = $("div[data-role='footer']");
				// make sure the footer is visible
				ok($footer.is(":visible"), "Footer is visible");
				// make sure Complete link is present
				ok($footer.find("#footer-search-all-btn").is(":visible"), "Complete link is visible");
				next();
			},
			openCompletePage,
			function (next) {
				// make sure the "Find Facility" box is visible (MDPD-1420)
				ok($("#facilityName").is(":visible"), "Find Facility box is visible");
				// make sure the Data Range selector is visible (MDPD-1422)
				ok($("#select-date-range").is(":visible"), "Data Range selector is visible");
				// make sure the "Search Organisms" box is *NOT* visible
				equal($("#organismName").is(":visible"), false, "Search Organisms box is *not* visible");
				
				var $footer = $("div[data-role='footer']");
				
				// make sure the footer is visible
				ok($footer.is(":visible"), "Footer is visible");
				
				// make sure all footer links are present (MDPD-1417)
				ok($footer.find("#footer-launchpad-btn").is(":visible"), "Launchpad link is visible");
				ok($footer.find("#footer-antibiogram-search-btn").is(":visible"), "Search link is visible");
				ok($footer.find("#footer-search-all-btn").is(":visible"), "Complete link is visible");
				ok($footer.find("#footer-about-btn").is(":visible"), "About link is visible");
				next();
			}, function(next) {
				next();
			}], start);
	
	});
	
	// THERE IS NO AC FOR THIS - AMANDA
	test("About page can be reached and contains correct elements", function() {
		stop();
		expect(4);
		async.series([function (next) {
				var $footer = $("div[data-role='footer']");
				// make sure the footer is visible
				ok($footer.is(":visible"), "Footer is visible");
				// make sure About link is present
				ok($footer.find("#footer-about-btn").is(":visible"), "About link is visible");
				next();
			},
			openAboutPage,
			function (next) {
				// make sure the "About" dialog is visible
				ok($("div[data-role='dialog']").find("h2:contains('About')").is(":visible"), "About dialog is visible");
				next();
			}, function(next) {
				next();
			}], start);

	});
});