define([
	'jQuery',
	'../helpers'
], function($$, helpers) {
		
	module("#628 Organism View");
	
	//***** FUNCTIONS ******//
	
	function openSearchPage(next) {
		// click the Search button
		ok($( "#footer-antibiogram-search-btn" ).simulate("click"), "When I click the Search button");
		
		// best way is to listen to page load event
		setTimeout(function() {
			next();
		}, 1000);
	}
	//***** TESTS *****//
	
	
	test("When facility is entered on Search page, user can type and see list of organisms", function() {
		stop();
		//expect(16);
		async.series([function (next) {
				var $footer = $("div[data-role='footer']");
				// make sure the footer is visible
				ok($footer.is(":visible"), "Footer is visible");
				// make sure Search link is present
				ok($footer.find("#footer-antibiogram-search-btn").is(":visible"), "Search link is visible");
				next();
			},
			openSearchPage,
			function (next) {
				// make sure the "Find Facility" box is visible
				ok($("#facilityName").is(":visible"), "Find Facility box is visible");
				// populate box
				ok($("#facilityName").val("DC VAMC"), "When I type 'DC VAMC' into the box");
				// check contents of box
				equal($("#facilityName").val(), "DC VAMC", "What I typed is in the box");
				// populate hidden field
				ok($("#facilityCode").val("688"), "When I populate the hidden field");
				// check contents of hidden field
				equal($("#facilityCode").val(), "688", "Facility code is populated");
				// make sure the "Search Organisms" box is visible
				ok($("#organismName").is(":visible"), "Search Organisms box is visible");
				setTimeout(function() {
					next();
				}, 100);
			},
			function (next) {
				// selecting an organism from the list of organisms 
				ok($("#organismName").val("ESCHERICHIA COLI").trigger("keydown"), "When I type 'ESCHERICHIA COLI' in the box");
				equal($("#organismName").val(), "ESCHERICHIA COLI", "What I typed is in the box");
				// populate hidden field
				ok($("#organismId").val("1400002234"), "When I populate the hidden field");
				// check contents of hidden field
				equal($("#organismId").val(), "1400002234", "Organism id is populated");
				setTimeout(function() {
					next();
				}, 100);
			},
			//clicking ESCHERICHIA COLI from the organisms list
			function (next) {
				$('.ui-autocomplete').eq(1).find('a').eq(0).trigger("click");
				setTimeout(function() {
					next();
				}, 100);
			},
			//checking contents of the antibiotic table and verifying sort
			function (next) {
				ok($('td:contains("AMIKACN")' ).is(":visible"), "antibiotic column is visible");
				ok($('td:contains("100.0%")' ).is(":visible"), "Susceptibility column is visible");
				ok($( "th.antibiotic" ).simulate("click"), "When I click the column header Antibiotic");
				ok($("tr.odd").first().find('td:contains("TRMSULF")').is(":visible"), "anitbiotic column is sorted");
				ok($( "th.percent" ).simulate("click"), "When I click the column header susceptibility");
				//to get a different value in the first row susceptibility column header is clicked again
				ok($( "th.percent" ).simulate("click"), "When I click the susceptibility link second time");
				ok($("tr.odd").first().find('td:contains("100")').is(":visible"), "susceptibility column is sorted two times");
				setTimeout(function() {
					next();
				}, 100);
			}], start);
	});
});