define([
	'jQuery',
	'../helpers'
], function($$, helpers) {
		
	module("#1074 Antibiogram Organism Search");
	
	//***** FUNCTIONS ******//
	
	function openSearchPage(next) {
		// click the Search button
		ok($( "#footer-antibiogram-search-btn" ).simulate("click"), "When I click the Search button");
		
		// best way is to listen to page load event
		setTimeout(function() {
			next();
		}, 1000);
		
	}

	//***** TESTS *****//
	
	// Acceptance Criteria MDPD-652
	test("When facility is entered on Search page, user can type and see list of organisms", function() {
		stop();
		expect(11);
		async.series([function (next) {
				var $footer = $("div[data-role='footer']");
				// make sure the footer is visible
				ok($footer.is(":visible"), "Footer is visible");
				// make sure Search link is present
				ok($footer.find("#footer-antibiogram-search-btn").is(":visible"), "Search link is visible");
				next();
			},
			openSearchPage,
			function (next) {
				// make sure the "Find Facility" box is visible
				ok($("#facilityName").is(":visible"), "Find Facility box is visible");
				// populate box
				ok($("#facilityName").val("DC VAMC"), "When I type 'DC VAMC' into the box");
				// check contents of box
				equal($("#facilityName").val(), "DC VAMC", "What I typed is in the box");
				// populate hidden field
				ok($("#facilityCode").val("688"), "When I populate the hidden field");
				// check contents of hidden field
				equal($("#facilityCode").val(), "688", "Facility code is populated");
				// make sure the "Search Organisms" box is visible
				ok($("#organismName").is(":visible"), "Search Organisms box is visible");
				// type "as" in the box
				ok($("#organismName").val("as").trigger("keydown"), "When I type 'as' in the box");
				next();
			},
			function (next) {
				setTimeout(function() {
					// list appears (MDPD-652)
					ok($("ul.ui-autocomplete li.ui-menu-item:contains('PSEUDOMONAS')").is(":visible"), "'PSEUDOMONAS' is visible in list");
					next();
				}, 1000);
			}], start);
	});
});
	