require.config({
	paths: {
		// path configuration assumes .js suffix

		// Libraries
		'jQuery': '../../js/libs/jquery-1.8.2.min',
		'jQM': '../../js/libs/jquery.mobile-1.3.0.min',
		'Underscore': '../../js/libs/underscore',
		'JSON2': '../../js/libs/json2',
		'Backbone': '../../js/libs/backbone',
		'Global': '../../js/global',

		// Custom Helpers
		'jQMConfig': '../../js/libs/jqm-config', // Disables JQM Routing
		'Utilities': '../../js/utilities',
		'App': 'app',

		// Collections
		'Resources': '../../js/collections/resources',

		// Models
		'ResourceLink': '../../js/models/resourceLink',
		'User': '../../js/models/user',
		'StaffUserDisclaimer': '../../modules/js/models/staffUserDisclaimer',

		// require js plugins
		'Text': '../../js/text'
    },
    waitSeconds: 30,
	shim: {
		'jQuery': {
			exports: '$'
		},
		'jQMConfig': {
			deps: ['jQuery']
		},
		'jQM': {
			deps: ['jQMConfig']
		},
		'Underscore': {
			exports: '_'
		},
		'Backbone': {
			deps: ['jQuery', 'Underscore', 'JSON2'],
			exports: 'Backbone'
		},
		'Utilities': {
			deps: ['Backbone']
		},
		'Global': {
			deps: ['Backbone', 'jQM']
		}
	}
});

require(['App']);
