/* JS Document */

/**
*
* @project SUD: Mobile Blue Button
* @version v1.2
* @package javascript/ jquery-mobile, backbone.js, underscore.js
* @author Agilex
* @jsdoc version 1
*
*/

define([
	'Backbone',
	'User',
	'StaffUserDisclaimer',
	'Text!../html/sud.html'
],
function(Backbone, user, staffUserDisclaimerModel, sudTemplate) {
	var SudView = Backbone.View.extend({
		id: "sud",
		attributes: {"data-role": "dialog"},
		classname: "type-interior",
		initialize: function(){
			this.template = _.template(sudTemplate);
			this.destination = this.getFirstParam();
		},
		render: function(){
			var that = this,
				$container = $(this.el);
			staffUserDisclaimerModel.fetch({
				url: user.get('staff-user-disclaimer-content').href,
				success: function(response) {
					$container.append(that.template({content: response.get('content')}));
					$('body').append($container);
					$.mobile.changePage('#sud');
				}
			});
		},
		events: {
			'tap #accept-btn': 'acceptSud',		// for some reason need to input command "$('#accept-btn').trigger('tap')" to trigger method
			'tap #decline-btn': 'declineSud',
			'tap .ui-header a[Title="Close"]': 'declineSud'
		},
		acceptSud: function(){
			var that = this;
			staffUserDisclaimerModel.save({staffUserDisclaimerAccepted: true}, {
				success: function() {
					var pathname = window.location.href,
						url = that.destination;

					if (!url) {
						var referencePath = window.location.protocol + "//" + window.location.host + window.location.pathname;
						url = referencePath + "../launchpad/";
					}

					window.location = url;
				}
			});

		},
		declineSud: function(e){
			e.preventDefault();
			window.location = referencePath + '../launchpad';
		},
		getFirstParam: function() {
			var url = location.search.substring(1);
			url = url.replace('url=','');
			return url;
		}
	});
	var sudView = new SudView().render();
});