define([
	'Global',
	'Sm',
	'itemListView',
	'folderListView',
	'editListView',
	'Text!../../html/templates/common/secondary.html'
	],
	function(Global, Sm, ItemListView, FolderListView, EditListView, secondaryTemplate) {
		var SecondaryView = Backbone.View.extend({
			tagName: 'div',
			id: 'content-secondary',
			attributes: {"class": "content-secondary", "data-tap-toggle": "false"},
			initialize: function() {
				this.template = _.template(secondaryTemplate);
			},
			render: function() {
				var template = this.template,
					itemListView = new ItemListView(),
					container = $(this.el),
					domTarget = $('div.scrollable', container),
					listContainer;

				container.empty().append(template());
				domTarget.append(itemListView.render(Sm.getConstants().INBOX_FOLDER));
				return container;
			}
		});


		return new SecondaryView();
	}
);
