define([
	'Global',
	'Text!../html/templates/navbars/secondaryHeader.html'
	],
	function(Global, secondaryHeader) {
		var SecondaryHeaderView = Backbone.View.extend({
			initialize: function() {
				this.template = _.template(secondaryHeader);
			},
			render: function(details) {
				var compiledTemplate = this.template,
					container = $(this.el);
				container.empty().append(compiledTemplate(details));
				$('#content-secondary').find(":jqmData(role='header')").empty().append(container).trigger('create');
			},
			events: {
				"tap #Folders-btn" : "showFolders",
				"tap #Edit-btn" : "editItems",
				"tap #Cancel-btn" : "cancelEditItems"
			},
			showFolders: function(e) {
				e.preventDefault();
				Global.getUtilities().eventAggregator.trigger("goToFolderList", e);
			},
			editItems: function(e) {
				e.preventDefault();
				var folderTitle = $(e.currentTarget).siblings('h3').attr('name');
				Global.getUtilities().eventAggregator.trigger("goToEditList", folderTitle);
				
			},
			cancelEditItems: function(e) {
				e.preventDefault();
				var folderTitle = $(e.currentTarget).siblings('h3').attr('name');
				Global.getUtilities().eventAggregator.trigger("goToList", folderTitle);
			}
		});
		return SecondaryHeaderView;
	}
);