define([
	'Global',
	'Sm',
	'SecureMessageUser',
	'Text!../html/templates/navbars/primaryHeader.html',
	],
	function(Global, Sm, secureMessageUser, primaryHeader) {
		var PrimaryHeaderView = Backbone.View.extend({
			initialize: function() {
				this.template = _.template(primaryHeader);
			},
			render: function() {
				var container = $(this.el);

				container.empty().append(this.template({title: 'Secure Messaging'}));
				
				return container;
			},
			events: {
				"tap #primary-reply-btn" : "replyItem",
				"tap #primary-move-btn" : "moveMenu",
				"tap #primary-delete-btn" : "deleteItem",
				"tap #primary-new-btn" : "composeItem",
				"tap #primary-print-btn" : "printItem"
			},
			editItem: function(action, folder) {
				var message = $(document).jqmData('selectedMsg');
				message.set('folderId', folder);
				action(message, this);
			},
			deleteItem: function(e) {
				e.preventDefault();
				this.editItem(Sm.getUtilities().httpDelete, e.currentTarget.name);
			},
			moveMenu: function(e) {
				e.preventDefault();
				var targetId = '#' + e.currentTarget.id,
					scope = this;
       
				$('#move-menu').popup('open', {positionTo: targetId});
				$('#move-menu').on('tap', 'a', function(){
       
					scope.editItem(Sm.getUtilities().httpPut, this.name);
					$('#move-menu').popup('close');
				});
			},
			composeItem: function(e) {
				e.preventDefault();
				$('#new-send-btn, #new-actions-btn').removeClass('ui-disabled');
				Global.getUtilities().eventAggregator.trigger("composeMsg");
			},
			replyItem: function(e) {
				e.preventDefault();
				var message = $(document).jqmData('selectedMsg');
				var folder = message.get('folder');
				$(document).jqmData('replyMsg', message);
				$('#new-send-btn, #new-actions-btn').removeClass('ui-disabled');
				if (folder == 'Drafts') {
					Global.getUtilities().eventAggregator.trigger("completeMsg");
				} else {
					Global.getUtilities().eventAggregator.trigger("replyMsg");
				}
			},
			printItem: function(e) {
				e.preventDefault();

                var linkArray = $(document).jqmData('selectedMsg').get('link');

                for(link in linkArray){
                    if(linkArray[link].title == "print"){
                        window.open(linkArray[link].href);
                        break;
                    }
                }
			}
		});
		return PrimaryHeaderView;
	}
);