define([
	'Global',
	'Text!../html/templates/panes/noAccount.html'
	],
	function(Global, noAccountTemplate ) {
		var NoAccountView = Backbone.View.extend({
			id: 'no-account-dialog',
			attributes: {'data-role': 'dialog'},
			initialize: function() {
			},
			render: function() {
				var compiledTemplate = _.template(noAccountTemplate),
					container =  $(this.el);
				container.empty().append(compiledTemplate());
				$('body').append(container).trigger('create');
			},
			clear: function() {
				
			},
			events: {
				"tap #close-dialog-btn": "goToLaunchpad"
			},
			goToLaunchpad: function(event) {
				event.preventDefault();

				Global.getUtilities().eventAggregator.trigger("showNoAccount");
				window.location = Global.getUtilities().getReferencePath() + "../launchpad/";
			}
		});
		return NoAccountView;
	}
);