define([
	'Global',
	'Sm',
	'detailsView',
	'secondaryHeaderView',
	'SecureMessages',
	'Text!../html/templates/lists/listItemTo.html',
	'Text!../html/templates/lists/listItemFrom.html'
	],
	function(Global, Sm, DetailsView, SecondaryHeaderView, SecureMessages, listItemTo, listItemFrom) {
		//var secureMessages = new SecureMessages(),
			ItemListView = Backbone.View.extend({
				tagName: 'ul',
				id: 'inbox-list',
				attributes: {"data-role": 'listview', "data-divider-theme": 'd' },

				render: function(folder) {
					if (typeof folder === 'undefined' || typeof folder === null) {
						folder = $(document).jqmData('currentFolder');
					}
					var container = $(this.el),
						secondaryHeaderView = new SecondaryHeaderView();
						markMessageRead = this.markMessageRead,
						scope = this;
					if (typeof folder === "undefined") {
						folder = Sm.getConstants().INBOX_FOLDER;
					}

					$(document).jqmData('currentFolder', folder);
					// $('#list-loader').popup('open', {positionTo: '#content-secondary li:last-child'});

					Sm.getUtilities().fetchData(folder, function(secureMessages) {
						container.empty();
						var itemCount = 0,
							template;

						if (folder == 'Sent' || folder == 'Drafts') {
							template = _.template(listItemTo);
						} else {
							template = _.template(listItemFrom);
						}
						secureMessages.each(function(message) {
							container.append(template(message.toJSON()));

							var readDate = message.get('readDate');
							if (typeof readDate === 'undefined' || !readDate) {
								itemCount++;
							} else {
								markMessageRead($('li:last a', container));
							}
						});
						var actions = {title: folder, leftAction: 'Folders', rightAction: 'Edit', itemCount: itemCount};

						if (folder == 'Sent') {
							actions = {title: folder, leftAction: 'Folders', itemCount: itemCount};
							secondaryHeaderView.render(actions);
						} else {
							secondaryHeaderView.render(actions);
						}
						$('#content-secondary .scrollable').empty().append(container).trigger('create');
						Global.getUtilities().resizePanes();

						var recentMessage = $(document).jqmData('selectedMsg' + folder);

						if (typeof recentMessage !== "undefined") {
							$("#" + recentMessage.id).trigger('tap', ['simulatedClick']);
							details = new DetailsView({model: recentMessage});
							details.render();
						}
						//conflict with move menu?  
						// $('#list-loader').removeClass('ui-popup-active').addClass('ui-selectmenu-hidden').removeAttr('style');
						// $('#list-loader-screen').removeClass('in').addClass('ui-screen-hidden');
						// $('#list-loader').popup('close');
					});

				},
				events: {
					"tap .inbox-list-item": "showMsgDetails"
				},

				markMessageRead: function(item) {
					$(item).addClass('read-message');
				},

				showMsgDetails: function(e, simulatedClick) {
					e.preventDefault();

					var item = e.currentTarget.id,
						folder = $(document).jqmData('currentFolder'),
						messages = $(document).jqmData('secureMessages' + folder),
						message = messages.get(item), //e.currentTarget for this element
						fullMessage,
						details;

					var readDate = message.get('readDate');
					if (typeof readDate === 'undefined' || !readDate) {
						this.markMessageRead(e.currentTarget);
						var count = $('#item-count').text();
						count--;
						$('#item-count').text(count);
					}

					fullMessage = message;
					message.save({},{
						url: getUriByTitle(fullMessage.get('link'),'read'),
						success: function(response){
							fullMessage.set('messageBody', response.get('messageBody'));
							details = new DetailsView({model: fullMessage});
							details.render();
							$(document).jqmData('selectedMsg', fullMessage);
							$(document).jqmData('selectedMsg' + fullMessage.get('folder'), fullMessage);
						}
					});
					if (typeof simulatedClick === 'undefined') {
						Global.getUtilities().slidePrimary();
					}
					var itemParent = $('#'+item).parents('li');
					itemParent.attr('data-theme','b').removeClass('ui-btn-up-c').removeClass('ui-btn-hover-c').addClass('ui-btn-up-b');
					itemParent.siblings('li').attr('data-theme','c').removeClass('ui-btn-up-b').removeClass('ui-btn-hover-b').addClass('ui-btn-up-c');
				}
			});
		return ItemListView;
	}
);
