define([
	'Global',
	'Sm',
	'SecureMessageFolders',
	'itemListView',
	'detailsView',
	'secondaryHeaderView',
	'Text!../html/templates/lists/folderItem.html'
	],
	function(Global, Sm, SecureMessageFolders, ItemListView, DetailsView, SecondaryHeaderView, folderItem) {
		var FolderListView = Backbone.View.extend({
	
			tagName: 'ul',
			id: 'folder-list',
			attributes: {"data-role": 'listview', "data-divider-theme": 'd', "class":'no-scroll-event'  },
			render: function() {
				var container = $(this.el),
				secureMessageFolders = new SecureMessageFolders(),
					template = _.template(folderItem);
				
				container.empty();
				secureMessageFolders.each(function(folder) {
					container.append(template(folder.toJSON()));
				});
				$('#content-secondary div.scrollable').html(container).trigger('create');
				var secondaryHeaderView = new SecondaryHeaderView();
				secondaryHeaderView.render({title: 'Folders'});
			},
			events: {
				"tap .folder-list-item": "showSelectedFolder"
			},
			
			showSelectedFolder: function(e) {
				Sm.getUtilities().removeDetailedMsg();
				e.preventDefault();
				var folder = $('h3', e.currentTarget).text();
				Global.getUtilities().eventAggregator.trigger("goToList", folder);
			}
		});
		return FolderListView;
	}
);
