define([
	'Global',
	'editActionsView',
	'secondaryHeaderView',
	'SecureMessage',
	'SecureMessages',
	'Text!../html/templates/lists/editListItem.html'
	],
	function(Global, EditActionsView, SecondaryHeaderView, SecureMessage, SecureMessages, listItem) {
			var editListView = Backbone.View.extend({
				tagName: 'ul',
				id: 'inbox-list',
				attributes: {"data-role": 'listview', "class" : 'ui-selectmenu-list no-scroll-event' },

				render: function(folderTitle) {
					var container = $(this.el),
					actionsContainer,
					secureMessages = $(document).jqmData('secureMessages' + folderTitle);
					template = _.template(listItem);
					
					container.empty();
					
					secureMessages.each(function(message) {
						container.append(template(message.toJSON()));
					});

					$('#content-secondary div.scrollable').empty().append(container).append(actionsContainer).trigger('create');
					var editActionsView = new EditActionsView();
					editActionsView.render(folderTitle);
					var secondaryHeaderView = new SecondaryHeaderView();
					secondaryHeaderView.render({title: folderTitle, leftAction: 'Folders', rightAction: 'Cancel'});
				},
				events: {
					"tap .edit-list-item": "checkItem"
				},
				checkItem: function(e) {
					e.preventDefault();
					item = e.currentTarget.id;
					
					$('span.ui-icon', e.currentTarget).toggleClass('ui-icon-checkbox-off').toggleClass('ui-icon-checkbox-on');
					$('#action-list').find('a').removeClass('ui-disabled');
				}
			});
		return editListView;
	}
);