define([
	'Global',
	'Sm',
	'SecureMessageFolders',
	'Text!../html/templates/navbars/editActionsMenu.html',
	'Text!../html/templates/menus/moveMenu.html'
	],
	function(Global, Sm, SecureMessageFolders, editActionsMenu, moveMenu) {
			var editActionsView = Backbone.View.extend({
				tagName: 'div',
				id: 'action-list',
				attributes: { "class": "ui-body ui-body-e" },
			
				render: function(folderTitle) {
					var container = $(this.el),
					actions = {moveBtn: true, deleteBtn: true};
					template = _.template(editActionsMenu);
					moveTemplate = _.template(moveMenu);
					container.empty();
					var secureMessageFolders = new SecureMessageFolders();
					var availableMessageFolders = new SecureMessageFolders();
					availableMessageFolders.remove(secureMessageFolders.get(folderTitle));
					availableMessageFolders.remove(secureMessageFolders.get(Sm.getConstants().SENT_FOLDER));
					availableMessageFolders.remove(secureMessageFolders.get(Sm.getConstants().DRAFTS_FOLDER));
					availableMessageFolders.remove(secureMessageFolders.get(Sm.getConstants().DELETED_FOLDER));

					var folderUniqueId = secureMessageFolders.get(folderTitle).get('dataIdentifier').uniqueId;
					if (folderTitle != Sm.getConstants().DELETED_FOLDER && folderUniqueId <= 0) {
						availableMessageFolders.remove(secureMessageFolders.get(Sm.getConstants().INBOX_FOLDER));
					}

					if (folderTitle == Sm.getConstants().DRAFTS_FOLDER) {
						actions = {moveBtn: false, deleteBtn: true};
					} else if (folderTitle == Sm.getConstants().DELETED_FOLDER) {
						actions = {moveBtn: true, deleteBtn: false};
					};
					$('#multi-move-menu-popup, #multi-move-menu-screen').remove();
					container.append(template(actions));
					container.append(moveTemplate({folders: availableMessageFolders.toJSON(), id: 'multi-move-menu'}));
					
					$('#content-secondary div.scrollable').append(container).trigger('create');
				},
				events: {
					"tap #action-delete-btn": "deleteItem",
					"tap #action-move-btn": "moveMenu"
				},
				editItem: function(action, folderId) {
					var messages = $(document).jqmData('secureMessages' + $(document).jqmData('currentFolder')),
					size,
					checkedMessages = $('#content-secondary ul').find('.ui-icon-checkbox-on').parents('a');
					size = checkedMessages.length;
					for(var i=0; i<size; i++) {
						var message = messages.get($(checkedMessages[i]).attr('id'));
						var folder = message.get('folder');
						message.set('folderId', folderId);
						action(message, folder);
					}
				},
				moveMenu: function(e) {
					var scope = this;
					var targetId = '#' + e.currentTarget.id;
					$('#multi-move-menu').popup('open', {positionTo: targetId});
					$('#multi-move-menu').on('tap', 'a', function(){
						scope.editItem(Sm.getUtilities().httpPut, this.name);
						$('#multi-move-menu').popup('close');
					});
				},
				moveItem: function(e) {
					this.editItem(Sm.getUtilities().httpPut, e.currentTarget.name);
				},
				deleteItem: function(e) {
					this.editItem(Sm.getUtilities().httpDelete, e.currentTarget.name);
				}
			});
		return editActionsView;
	}
);