define([
	'Global',
	'SecureMessageFolders',
	'Text!../html/templates/panes/details.html',
	'Text!../html/templates/menus/moveMenu.html'
	],
	function(Global, SecureMessageFolders, detailsTemplate, moveMenu) {
		var detailsView = Backbone.View.extend({
			tagName: 'ul',
			attributes: {"data-role": "listview", "class": "ui-shadow"},
			initialize: function() {
				this.template = _.template(detailsTemplate);
				this.moveTemplate = _.template(moveMenu);
			},
			render: function() {
				var message = this.model,
					template = this.template,
					moveTemplate = this.moveTemplate,
					secureMessageFolders = new SecureMessageFolders(),
					availableMessageFolders = new SecureMessageFolders(),
					folderTitle = message.get('folder'),
					moveMenu,
					popup = $('#move-menu-popup');
					container = $(this.el);
				if (typeof popup !== 'undefined') {
					popup.empty();
				}
				availableMessageFolders.remove(secureMessageFolders.get(folderTitle));
				secureMessageFolders.each(function(folder) {
					var id = folder.get('dataIdentifier').uniqueId;
					if (id < 0){
						availableMessageFolders.remove(folder);
					}
				});

				$('#slide-btn').removeClass('ui-disabled');
				if (folderTitle == 'Drafts') {
					$('#primary-delete-btn, #primary-reply-btn, #primary-print-btn').removeClass('ui-disabled');
				} else if (folderTitle == 'Sent') {
					$('#primary-print-btn').removeClass('ui-disabled');
				} else if (folderTitle == 'Deleted') {
					$('#primary-move-btn, #primary-print-btn').removeClass('ui-disabled');
				} else {
					$('#primary-move-btn, #primary-delete-btn, #primary-reply-btn, #primary-print-btn').removeClass('ui-disabled');
				}

				container.empty();
				moveMenu = moveTemplate({folders: availableMessageFolders.toJSON(), id: 'move-menu'});
				container.append(template(message.toJSON()));
				$('#content-primary .scrollable').empty().append(container).append(moveMenu);
				container.parent().trigger('create');
			}
		});
		 
		return detailsView;
	}
);