define([
	'Global',
	'SecureMessageUser',
	'User',
	'SecureMessage',
	'SecureMessageContacts',
	'Text!../html/templates/panes/compose.html',
	'Text!../html/templates/panes/reply.html'
	],
	function(Global, SecureMessageUser, user, SecureMessage, SecureMessageContacts, composeTemplate, replyTemplate) {
		var secureMessageUser = SecureMessageUser.instance(),
			currentMessage;
		var ComposeView = Backbone.View.extend({
			id: 'compose-dialog',
			attributes: {'data-role': 'dialog'},
			initialize: function(type) {
				this.type = type;
				if (type === 'reply') {
					this.template = _.template(replyTemplate);
				} else {
					this.template = _.template(composeTemplate);
				}
				this.currentFolder = $(document).jqmData('currentFolder');
			},
			render: function() {
				var template = this.template,
					type = this.type,
					contacts = new SecureMessageContacts(),
					container =  $(this.el),
					model = this.model = $(document).jqmData('replyMsg');
				if (typeof model !== "undefined" && typeof type != "undefined") {
					currentMessage = model;
					model = model.toJSON();
				}
				var inquiries = ['General', 'Medication', 'Appointment', 'Test'];
				var renderedHtml = template($.extend({}, model, {inquries: inquiries, contacts: contacts.toJSON()}));
				container.empty().append(renderedHtml);
				$('body').append(container);
			},
			clear: function() {
				
			},
			events: {
				"tap #new-actions-btn": "cancelActions",
				"tap #new-send-btn": "sendMsg",
				"keyup form": "formValidation",
				"change #new-subject-select": "subjectCategoryChange",
				"change #new-subject-line": "subjectChange",
				"change #new-body": "bodyChange"
			},
			createMsg: function() {
				var formJSON = $(this.el).find(":jqmData(role='content') form").formParams();
				var message;
				if (this.type == 'complete') {
					currentMessage.set(formJSON);
					message = currentMessage;
				}
				else {
					message = new SecureMessage(formJSON);
				}
				message.set({
					'mailGroup': message.get('toId'),
					'from': user.get('displayName'),
					'fromId': secureMessageUser.get('patientIdentifier').uniqueId,
				});
				if (typeof message.get('to') == 'undefined' ) {
					message.set({
						'to': $('#new-to').parent().find('.ui-btn-text').text()
					});
				}
				if (this.type == "complete") {
					message.url = getUriByTitle(this.model.get('link'),'send');
				} else if(this.type == "reply") {
					message.set({
						'replyToMessageId': this.model.id
					});
					message.url = getUriByTitle(this.model.get('link'),'reply');
				} else {
					message.url = secureMessageUser.get('sendUri');
				}
				return message;
			},
			cancelActions: function(e) {
				e.preventDefault();
				var scope = this,
					id = this.id,
					folder = this.currentFolder,
					targetId = '#' + e.currentTarget.id;
				$('#draft-menu').popup('open', {positionTo: targetId});
				$('#draft-menu').on('tap', 'a', function(){
					$('#new-send-btn, #new-actions-btn').addClass('ui-disabled');
					actionName = $(this).attr('name');
					if (actionName == 'Delete') {
						$('#draft-menu').popup('close');
						Global.getUtilities().eventAggregator.trigger("home");
					} else if (actionName == 'Drafts') {
						var message = scope.createMsg();
						message.save({},{
							url: secureMessageUser.get('saveDraftUri'),
							success: function(response){
								$('#draft-menu').popup('close');
								Global.getUtilities().eventAggregator.trigger("home");
							}
						});
					}
				});
			},
			sendMsg: function(e) {
				e.preventDefault();
				$('#new-send-btn, #new-actions-btn').addClass('ui-disabled');
				var targetId = '#' + e.currentTarget.id,
					message = this.createMsg(),
					loader = $('#send-loader'),
					folder = this.currentFolder;
				loader.popup('open');
				message.save({},{
					success: function(response) {
						loader.find('h3').text('Message Sent');
						loader.find('img').remove();
						setTimeout(function() {
							Global.getUtilities().eventAggregator.trigger("home");
						}, 2000);
					},
					error: function() {
						loader.find('h3').text('Error!');
						loader.find('img').remove();
					}
				});
			},
			subjectCategoryChange: function(e) {
				var subjectLine = $('#new-subject-line');
				if (!(subjectLine.hasClass('static')) || subjectLine.val() == '') {
					if (subjectLine.val() == '') {
						subjectLine.removeClass('static');
					}
					var newSubjectValue = e.currentTarget.selectedOptions[0].innerText;
					subjectLine.val(newSubjectValue);
				}
			},
			subjectChange: function(e) {
				var targetId = '#' + e.currentTarget.id,
					target = $(targetId);
				target.addClass('static');
				target.blur(function() {
					target.val(target.val().substring(0,50));

				});
			},
			bodyChange: function(e) {
				var targetId = '#' + e.currentTarget.id,
					target = $(targetId);
				target.addClass('static');
				target.blur(function() {
					target.val(target.val().substring(0,5000));
				});
			},
			formValidation: function() {
				var message = $("form").formParams(),
					values = _.values(message);
					size = values.length;
				if (_.without(values, "").length == size){
					$('#new-send-btn').removeClass('ui-disabled');
				} else {
					$('#new-send-btn').addClass('ui-disabled');
				}
			}
		});
		return ComposeView;
	}
);