define([
    'Global',
	'SecureMessageFolders',
	'SecureMessages'
	],

	function(Global, SecureMessageFolders, SecureMessages) {
		var utilities = { },
			dataLoading = false,
			scrollLoad = false,
			endOfMessages = false,
			scrollDirection,
			secureMessageFolders = new SecureMessageFolders();

		utilities.attachPostEvents = function() {
			var tempScrollTop, currentScrollTop = 0;
			$('#content-secondary .scrollable').scroll(function(){
				if (!$('> ul', this).hasClass('no-scroll-event')) {
					currentScrollTop = $(this).scrollTop();

					if (tempScrollTop < currentScrollTop )
						scrollDirection = "down";
					else if (tempScrollTop > currentScrollTop )
						scrollDirection = "up";

					tempScrollTop = currentScrollTop;

					if (!endOfMessages && scrollDirection === "down") {
						var triggerPoint = 100; // 100px from the bottom
						
						if (!dataLoading && triggerPoint + this.clientHeight + this.scrollTop > this.scrollHeight) {
							scrollLoad = true;
							Global.getUtilities().eventAggregator.trigger("goToList", $(document).jqmData('currentFolder'));
						}
					}
					if (!dataLoading && currentScrollTop < 10 && scrollDirection === "up") {
						$(document).jqmRemoveData('secureMessages' + $(document).jqmData('currentFolder'));
						Global.getUtilities().eventAggregator.trigger("goToList", $(document).jqmData('currentFolder'));
					}
				}
			});
		};

		utilities.fetchData = function(folder, callbackFn) {
			dataLoading = true;
			endOfMessages = false;
			var secureMessages = new SecureMessages(),
				folderUrl,
				size;
			if (typeof folder === "undefined") {
				folder = "Inbox";
			}

			if (typeof secureMessageFolders.get(folder).get('messages').next !== 'undefined' && scrollLoad === true) {
				folderUrl = secureMessageFolders.get(folder).get('messages').next;
			} else {
				folderUrl = secureMessageFolders.get(folder).get('messages').href;
			}
			
			var insureLoadOut = function(){
				dataLoading = false;
				scrollLoad = false;
			};
			
			secureMessages.fetch({
				url: folderUrl,
				success: function(collection){
					return buildCollection(collection, function(){
						insureLoadOut();
					});
				}
			});
			
			function buildCollection(collection, loadOut) {
				var combinedMessageCollection = collection;
				if (typeof collection.next === "undefined") {
					endOfMessages = true;
				} else {
					secureMessageFolders.get(folder).get('messages').next = collection.next;
				}
				
				var previousMessages = $(document).jqmData('secureMessages' + folder);
				if (typeof previousMessages !== 'undefined') {
					combinedMessageCollection.add(previousMessages.models);
				}
				
				$(document).jqmData('secureMessages' + folder, combinedMessageCollection);
			
				if ($.isFunction(loadOut)){
					loadOut.call();
				}

				if ($.isFunction(callbackFn)){
					callbackFn.call(this, combinedMessageCollection);
					// Disabling All Buttons
					$('#primary-move-btn, #primary-delete-btn, #slide-btn, #primary-reply-btn, #primary-print-btn').addClass('ui-disabled');
				}
			}
		};
		utilities.httpPut = function(message, callbackFn) {
			var currentfolder = message.get('folder');
			message.save({},{
				url: getUriByTitle(message.get('link'),'move'),
				success: function(response){
					utilities.removeItem(message, callbackFn);
					utilities.removeDetailedMsg(message, currentfolder);
				}
			});
		};
		utilities.httpDelete = function(message, callbackFn) {
			var currentfolder = message.get('folder');
			message.destroy({
				url: getUriByTitle(message.get('link'),'delete'),
				success: function(response){
					utilities.removeItem(message, callbackFn);
					utilities.removeDetailedMsg(message, currentfolder);
				}
			});
		};
		utilities.removeItem = function(message, callbackFn) {
			$('#' + message.id).animate({
				opacity: 0,
				height: 'toggle'
			}, 200, function() {
				$(this).parents('li').remove();
				if ($.isFunction(callbackFn))
					callbackFn.call();
			});
		};
		utilities.removeDetailedMsg = function(message, folder) {
			$('#content-primary .ui-listview').animate({
				opacity: 0,
				height: 'toggle'
			}, 200, function() {
				$(this).remove();
				if (typeof folder !== 'undefined') {
					$(document).jqmData('secureMessages' + folder).remove(message.id);
					$(document).jqmRemoveData('selectedMsg' + folder);
					Global.getUtilities().eventAggregator.trigger("goToList", folder);
					Global.getUtilities().slidePrimary();
					$('#slide-btn').addClass('ui-disabled');
				}

			});
		};

		var CONSTANTS = {
				INBOX_TITLE  : 'Inbox',
				INBOX_FOLDER  : 'Inbox',
				INBOX_LEFT_ACTION : 'Folders',

				SENT_TITLE  : 'Sent',
				SENT_FOLDER  : 'Sent',

				DRAFTS_FOLDER : 'Drafts',
				DELETED_FOLDER : 'Deleted'
		};

		return {
			getUtilities: function() {
				return utilities;
			},
			getConstants: function() {
				return CONSTANTS;
			}
		};
	}
);