define([
  'Global',
  'Sm',
  'User',
  'SecureMessageUser',
  'mainView',
  'folderListView',
  'editListView',
  'itemListView',
  'composeView',
  'aboutView',
  'noAccountView'
], function(Global, Sm, user, SecureMessageUser, MainView, FolderListView, EditListView, ItemListView, ComposeView, AboutView, NoAccountView) {
	// http://documentcloud.github.com/backbone/#Router
	var initialLoad = true;

	var AppRouter = Backbone.Router.extend({
		routes: {
			'compose': 'showComposePage',
			'complete': 'showCompletePage',
			'reply': 'showReplyPage',
			'about': 'showAboutPage',

			// Default
			'*actions': 'defaultAction'
		},

		//Pages
		showAboutPage: function(){
			this.openPage(new AboutView());
		},
		showComposePage: function(){
			this.openPage(new ComposeView());
		},
		showReplyPage: function(){
			if ($(document).jqmData('replyMsg')) {
				this.openPage(new ComposeView('reply'));
			} else {
				this.openPage(new ComposeView());
			}
		},
		showCompletePage: function(){
			this.openPage(new ComposeView('complete'));
		},
		defaultAction: function(){
			if (initialLoad && $.isEmptyObject(SecureMessageUser.instance().attributes)) {
				new NoAccountView().render();
			} else {
				this.openPage(new ItemListView()); //sets default view
			}
		},

		//route
		openPage: function(page){

			var pageType = $(page.el).eq(0).attr('data-role'),
				primaryView = $('#content-primary');
			this.buildMain.call(this, page);

			if (initialLoad) {
				initialLoad = false;
			} else if (pageType === 'dialog') {
				page.render();
				$.mobile.changePage("#" + page.id, {transition: 'pop'});
			} else {
				$('#main').animationComplete(function () {
					var renderedPage = page.render();

					if (renderedPage) {
						renderedPage.trigger('create');
					}

					if(primaryView.hasClass("closed")){
						Global.getUtilities().slidePrimary();
					}
				});
				$.mobile.changePage("#main", {allowSamePageTransition: true});
			}

			//Size scrollables
			setTimeout(function() {
				$(window).triggerHandler('resize');
			}, 100);
		},

		buildMain: (_.once(function(page){
			var mainView = new MainView();
			$('body').append(mainView.render());
			page.render();
			Global.getUtilities().globalInit({user: user});
			Sm.getUtilities().attachPostEvents();
		}))
	});

	var appRouter = new AppRouter();
	var eventAggregator = Global.getUtilities().eventAggregator;

	eventAggregator.on("home", function() {
		appRouter.navigate('', {trigger: true});
	});

	eventAggregator.on("goToList", function(folder) {
		if (folder !== 'Folders') {
			var itemListView = new ItemListView();
			itemListView.render(folder);
		} else {
			Global.getUtilities().eventAggregator.trigger("goToFolderList");
		}
	});

	eventAggregator.on("goToFolderList", function() {
	var folderListView = new FolderListView();
		folderListView.render();
	});

	eventAggregator.on("goToEditList", function(folder) {
		var editListView = new EditListView();
		editListView.render(folder);
	});

	eventAggregator.on("composeMsg", function() {
		appRouter.navigate('#compose', {trigger: true});
	});

	eventAggregator.on("replyMsg", function() {
		appRouter.navigate('#reply', {trigger: true});
	});

	eventAggregator.on("completeMsg", function() {
		appRouter.navigate('#complete', {trigger: true});
	});
	
	eventAggregator.on("about", function() {
		appRouter.navigate('#about', {trigger: true});
	});
	
	Backbone.history.start();
});