define(
	['Global', 'Backbone', 'User'],
	function(Global, Backbone, user) {
		var singleInstance;
		var SecureMessageUser = Backbone.Model.extend({
			url: user.get('securemessage-user').href,
			
			initialize: function() {
				this.fetch({async: false});
				Global.getUtilities().flattenLinks(this); 
			},
			parse: function(response) {
				// response will be null if user does not have SM id
				if (response !== null) {
					this.id = response.dataIdentifier.uniqueId;
				}
				return response;
			}
		});

		SecureMessageUser.instance = function() {
			if (typeof singleInstance === "undefined") {
				singleInstance = new SecureMessageUser();
			}
			return singleInstance;
		}

		return SecureMessageUser;	
	}
);