require.config({
	paths: {
		// path configuration assumes .js suffix

		// Libraries
		'jQuery': '../../js/libs/jquery-1.8.2.min',
		// custom version of jQM, see comments section in library for custom change log
		'jQM': '../../js/libs/jquery.mobile-1.2.0-CUSTOM',
		//'jQUI': '../../js/libs/jquery-ui-1.8.24.dev.min',
		'Underscore': '../../js/libs/underscore',
		'JSON2': '../../js/libs/json2',
		'Backbone': '../../js/libs/backbone',
		'FormParams': '../../js/libs/jquery.formparams',
		'Global': '../../js/global',
		'Sm': 'sm',
		'Confirm': '../../js/libs/jquery.confirm',

		// Custom Helpers
		'jQMConfig': '../../js/libs/jqm-config', // Disables JQM Routing
		'Utilities': '../../js/utilities',

		// Models
		'ResourceLink': '../../js/models/resourceLink',
		'User': '../../js/models/user',
		'UserSession': '../../js/models/userSession',
		'SecureMessageUser': 'models/secureMessageUser',
		'SecureMessageFolder': 'models/secureMessageFolder',
		'SecureMessageContact': 'models/secureMessageContact',
		'SecureMessage': 'models/secureMessage',
		'FooterButton': '../../js/models/footerButtonModel',

		// Collections
		'Resources': '../../js/collections/resources',
		'SecureMessageFolders': 'collections/secureMessageFolders',
		'SecureMessageContacts': 'collections/secureMessageContacts',
		'SecureMessages': 'collections/secureMessages',
		'FooterButtons':'../../js/collections/footerButtons',

		// Views
		'noAccountView': 'views/noAccountView',
		'mainView': '../../js/views/doubleColumnMainView',
		'footerView': '../../js/views/footerView',
		'secondaryView': '../../js/views/secondaryView',
		'primaryView': '../../js/views/primaryView',
		'itemListView': 'views/itemListView',
		'folderListView': 'views/folderListView',
		'detailsView': 'views/detailsView',
		'editListView': 'views/editListView',
		'editActionsView': 'views/editActionsView',
		'primaryHeaderView': 'views/primaryHeaderView',
		'secondaryHeaderView': 'views/secondaryHeaderView',
		'aboutView' : 'views/aboutView',
		'composeView': 'views/composeView',
		
		// require js plugins
		'Text': '../../js/text'
    },
    waitSeconds: 30,
	shim: {
		'jQuery': {
			exports: '$'
		},
		'jQMConfig': {
			//deps: ['jQUI'] // use jQUI as dependency if jQUI is required.  see https://github.com/jquery/jquery-mobile/issues/5119
			deps: ['jQuery']
		},
		'jQM': {
			deps: ['jQMConfig']
		},
		'FormParams': {
			deps: ['jQuery']
		},
		'Underscore': {
			exports: '_'
		},
		'Backbone': {
			deps: ['Underscore', 'jQM', 'JSON2', 'FormParams'],
			exports: 'Backbone'
		},
		'Utilities': {
			deps: ['jQuery','Backbone']
		},
		'Global': {
			deps: ['Backbone', 'Utilities']
		}
	}
});


require(['router']);
