define(
    ['Global', 'SecureMessage'],
    function(Global, secureMessage) {
        'use strict';
        return Backbone.Collection.extend({
            model: secureMessage,
            comparator: function (message) {
                return -new Date(message.get("dateSent")).getTime();
            },
            parse: function (response) {
                if (response.link[1] !== undefined) {
                    var action = response.link[1],
                        title = action.title;
                    this[title] = action.href;
                }
                this.pageNumber = response.pageNumber;
                return response.message;
            }
        });
    }
);
