/* JS Document */

/**
*
* @project SCHEDULING: Mobile Blue Button
* @version v0.7
* @package javascript/ jquery-mobile, backbone.js, underscore.js
* @author Agilex
* @jsdoc version 1
*
*/

(function($) {
	
	/** **** VIEWS ***** */
	
	m.AppointmentRequestDetailsView = Backbone.View.extend({
		tagName: 'div',
		initialize : function() {
			this.template = _.template($(
					'#appointment-request-details-template').html());
			this.patientTemplate = _.template($(
					'#request-patient-name-template').html());
			this.statusTemplate = _.template($(
					'#request-status-template').html());
		},
	
		render : function() {
			var container = this.options.viewContainer;
			if (this.model !== null) {

				var appointmentRequest = this.model,
					appointmentStatus,
					template = this.template,
					statusTemplate = this.statusTemplate,
					patientTemplate = this.patientTemplate,
					hideProcess = this.options.hideProcess,
					htmlContainer = $(this.el);

				if (this.options.allowProcess) {
					var inUse = this.model.get("beingProcessedBy");

					var lockedByUser = false;
					
					if (inUse) {
						if (inUse.userId === m.user.get('id')) {
							lockedByUser = true;
						} else {
							$('#process-request', htmlContainer).attr('disabled', 'true');
						}
					} else {
						inUse = false;
					}
					
					statusTemplate = statusTemplate($.extend({}, appointmentRequest.toJSON(), {inUse: inUse, lockedByUser: lockedByUser}));
					htmlContainer.append(statusTemplate);
					
					appointmentRequest = appointmentRequest.toJSON();
					patientTemplate = patientTemplate(appointmentRequest) + $(htmlContainer).html() + template(appointmentRequest);
				} else {
					appointmentRequest = appointmentRequest.toJSON();
					patientTemplate = patientTemplate(appointmentRequest) + template(appointmentRequest);
				}
			}
			container.html(patientTemplate);
			container.trigger('create');
			return this;
		}
	});
	
	m.ProcessRequestView = Backbone.View.extend({
		tagName: 'form',
		initialize : function() {
			this.saveTemplate = _.template($(
				'#save-form-template').html());
			this.actionTemplate = _.template($(
				'#take-action-template').html());
		},
	
		render : function() {
			var container = this.options.viewContainer,
				activeFormTitle = this.options.form,
				template = _.template($('#' + activeFormTitle + '-form-template').html());
				detailCodeTemplate = _.template($('#arDetailCodes-form-template').html()),
				saveTemplate = this.saveTemplate,
				actionTemplate = this.actionTemplate,
				arDetailCodes = this.options.arDetailCodes,
				request = this.model,
				formView = $(this.el).empty();

			var status = request.get('status');
			var visitType = request.get('visitType');

			formView.append(template(request.toJSON()));
			
			if (status == 'Submitted') {
				formView.prepend(actionTemplate());
				$('#' + activeFormTitle + '-btn', formView).addClass('ui-btn-active');
			}
			if (arDetailCodes.length > 0) {
				formView.append(detailCodeTemplate({ arDetailCodes: arDetailCodes }));
			}

			if (visitType === "Video Conference" && activeFormTitle === "Book") {
				formView.append(_.template($('#video-to-phone-template').html()));
			}

			container.html(formView);
			container.append(saveTemplate());
			container.trigger('create');
			return this;
		}
	});

	m.FooterView = Backbone.View.extend({
		initialize : function() {
			this.template = _.template($('#footer-template').html());
		},

		render : function() {
			var container = this.options.viewContainer;

			var model = this.model, template = this.template;
			var generatedHtml = template(model.toJSON());

			container.html(generatedHtml);

			container.trigger('create');
			resizePanes();
			return this;
		}
	});

	/** **** Functions ***** */
	m.initData = function() {
		m.userFeeds = new m.UserFeeds();		
		
		m.requestMetaData = new m.RequestMetaData();
		m.requestMetaData.fetch({
			async : false
		});
		
		m.appointmentRequest = new m.AppointmentRequest();
		
		initializeReloadDatatablesPlugin();
	};
	
	function initializeReloadDatatablesPlugin() {
		$.fn.dataTableExt.oApi.fnReloadAjax = function ( oSettings, sNewSource, fnCallback, bStandingRedraw ) {
			if ( typeof sNewSource != 'undefined' && sNewSource != null ) {
				oSettings.sAjaxSource = sNewSource;
			}

			// Server-side processing should just call fnDraw
			if ( oSettings.oFeatures.bServerSide ) {
				this.fnDraw();
				return;
			}

			this.oApi._fnProcessingDisplay( oSettings, true );
			var that = this;
			var iStart = oSettings._iDisplayStart;
			var aData = [];
		 
			this.oApi._fnServerParams( oSettings, aData );
			 
			oSettings.fnServerData.call( oSettings.oInstance, oSettings.sAjaxSource, aData, function(json) {
				/* Clear the old information from the table */
				that.oApi._fnClearTable( oSettings );
				 
				/* Got the data - add it to the table */
				var aData =  (oSettings.sAjaxDataProp !== "") ? that.oApi._fnGetObjectDataFn( oSettings.sAjaxDataProp )( json ) : json;
				 
				for ( var i=0 ; i < aData.length ; i++ ) {
					that.oApi._fnAddData( oSettings, aData[i] );
				}
				 
				oSettings.aiDisplay = oSettings.aiDisplayMaster.slice();
				 
				if ( typeof bStandingRedraw != 'undefined' && bStandingRedraw === true ) {
					oSettings._iDisplayStart = iStart;
					that.fnDraw( false );
				} else {
					that.fnDraw();
				}
				 
				that.oApi._fnProcessingDisplay( oSettings, false );
				 
				/* Callback user function - for event handlers etc */
				if ( typeof fnCallback == 'function' &&fnCallback != null ) {
					fnCallback( oSettings );
				}
			}, oSettings );
		};	
	}

	m.allowProcess = function(appointmentRequest) {
		var status = appointmentRequest.get('status'),
			detailCode = appointmentRequest.get('appointmentRequestDetailCode');

		if (detailCode.length > 0) {
			detailCode = detailCode[0].detailCode;
		} else {
			detailCode = null;
		}
		
		if (status == 'Submitted' || status == 'Booked' || (status == 'Cancelled' && detailCode.code == 'DETCODE8')){
			return true;
		}
		return false;
	};

	m.chooseForm = function(status) {
		switch (status) {
			case 'Submitted' :
				action = 'Book'
				break;
			case 'Booked' :
				action = 'Cancel'
				break;
			case 'Cancelled' :
				action = 'Cancel'
				break;
			case 'Not Booked' :
				action = 'Unavailable'
				break;
		}
		return action;
	};

	m.addDetailCodes = function(request, action) {
		var detailCodes = {};
	
		_.each(m.requestMetaData.get('detailCodes'), function(detailCode) {
			detailCodes[detailCode.code] = detailCode;
		});
	
		var	isSecondAttempt = request.get('secondRequest'),
		status = request.get('status'),
		arDetailCodes = [],
		existingAppointmentRequestDetailCodes = request.get('appointmentRequestDetailCode');
	
		switch (action) {
			case 'Book' :
				if (isSecondAttempt) {
					arDetailCodes.unshift(detailCodes['DETCODE2']);
				}
				break;
			
			case 'Cancel' :
				if (status == 'Cancelled' && existingAppointmentRequestDetailCodes != null) {
					var isCancellationConfirmedByClerk = false;
					_.each(existingAppointmentRequestDetailCodes, function(arDetCode){
						if(arDetCode.detailCode.code == 'DETCODE7'){
							isCancellationConfirmedByClerk = true;
						}
					});
					
					if (!isCancellationConfirmedByClerk) {
						arDetailCodes.unshift(detailCodes['DETCODE7']);
					}
				} else {
					arDetailCodes.unshift(detailCodes['DETCODE5']);
					arDetailCodes.unshift(detailCodes['DETCODE6']);
				}
				
				break;
			case 'Unavailable':
				if (isSecondAttempt) {
					arDetailCodes.unshift(detailCodes['DETCODE4']);
				} else {
					arDetailCodes.unshift(detailCodes['DETCODE3']);
				}
				break;
		}
		return arDetailCodes;
	};
	m.drawGrid = function(selectThisRowURL){
		// Custom Classes
		$.fn.dataTableExt.oStdClasses.sFilter = "ui-input-search ui-shadow-inset ui-btn-corner-all ui-btn-shadow ui-icon-searchfield ui-body-c";
		$.fn.dataTableExt.oStdClasses.sSortable = "ui-bar ui-bar-d";
		$.fn.dataTableExt.oStdClasses.sSortDesc = "ui-bar ui-bar-b";
		$.fn.dataTableExt.oStdClasses.sSortAsc = "ui-bar ui-bar-b";
		$.fn.dataTableExt.oStdClasses.sStripeOdd = "ui-btn ui-btn-icon-right ui-li-has-arrow ui-li ui-btn-up-c";
		$.fn.dataTableExt.oStdClasses.sStripeEven = "ui-btn ui-btn-icon-right ui-li-has-arrow ui-li ui-btn-up-c";
		
		var parentSiteCode = m.user.get('vistaLocation');
		var farthestTimeVeteranCanRequestAppointmentInDays = m.requestMetaData.get('farthestTimeVeteranCanRequestAppointmentInDays');
		var appointmentRequestsUrl = m.resources.get('appointment-requests').get('href') + '?startDate=' + subtractFromDate(0, farthestTimeVeteranCanRequestAppointmentInDays, 0, 0, 0, 0, 0, new Date());
		
		if (typeof parentSiteCode !== 'undefined' && parentSiteCode !== null) {
			appointmentRequestsUrl += '&parentSiteCode=' + parentSiteCode;
		}
		
		m.requestsTable = $('#appointmentRequestTable').dataTable({
			oLanguage : {
				"sSearch" : "",
				"sZeroRecords": "There are no matching records.",
				"sLengthMenu" : "Results _MENU_"
			},
			aaSorting : [],
			sDom : '<"top"f<"clear">>rt<"bottom"lp<"clear">>',
			bDestroy : true,
			bAutoWidth : false,
			bJQueryUI : false,
			bScrollCollapse: true,
			bProcessing : false,
			sAjaxDataProp : "appointmentRequest",
			sAjaxSource : appointmentRequestsUrl,
			aoColumns : [
				{
					"mDataProp" : "secondRequest"
				},
				{
					"mDataProp" : "patient.lastName"
				},
				{
					"mDataProp" : "patient.firstName"
				},
				{
					"mDataProp" : "facility.name"
				},
				{
					"mDataProp" : "appointmentType"
				},
				{
					"mDataProp" : "status"
				},
				{
					"mDataProp" : "lastUpdatedDate"
				},
				{
					"mDataProp" : null,
					"sDefaultContent" : '<span class="ui-icon ui-icon-arrow-r ui-icon-shadow">&nbsp;</span>'
				}],
			fnRowCallback : function(nRow, aData, iDisplayIndex, iDisplayIndexFull) {
				if (aData.secondRequest === true) {
					$('td:eq(0)', nRow)
							.html(
									'<span class="ui-icon ui-icon-refresh ui-icon-shadow">&nbsp;</span>');
				} else {
					$('td:eq(0)', nRow).empty();
				}
				$(nRow).attr({
					'data-selflink' : aData.link[0].href,
					'data-theme' : 'c',
					'data-role' : 'button'
				});

				if ($(nRow).attr('data-selflink') == selectThisRowURL) {
					$(nRow).addClass('selected-active');
				}
			},
			fnHeaderCallback : function(nHead, aData, iStart, iEnd, aiDisplay) {
				$('th:last-child', nHead).attr(
						'colspan', '2').addClass(
						'ui-bar ui-bar-d');
			},
			bPaginate : true,
			sPaginationType : "full_numbers",
			fnDrawCallback : function() {
				$('#appointmentRequestTable_filter input').attr("placeholder","Search…");
				$('#appointmentRequestTable_paginate').attr('data-role','controlgroup');
				$('#appointmentRequestTable_paginate a').attr({
					'data-theme' : 'c',
					'data-role' : 'button',
					'data-icon' : 'delete'
				});
			}
		});
	};

}(jQuery));

$('body').on('pageinit','#home',function(event) {
	globalInit();
	m.initData();
	$(window).resize(resizePanes);
	
	var footerViewContainer = $('#footer'), footerView;
	footerView = new m.FooterView({
		model : m.user,
		viewContainer : footerViewContainer
	});
	footerView.render();
});
$('body').on('pagebeforeshow','#home', function(){
	var request = m.appointmentRequest,
	url = request.get('url');
	request.id = request.get('dataIdentifier').uniqueId;
	if (url != null) {
		request.destroy({
			url: url + '/inprocess',
			success: function(model, response) { }
		});
	}
	var selectThisRowURL = (m.appointmentRequest.get('url') == null) ? "" : (m.appointmentRequest.get('url'));
	m.drawGrid(selectThisRowURL);
});

$('#appointmentRequestTable').on('tap','tr',function() {
	var row = $(this),
	selflink = row.jqmData('selflink');

	row.addClass('selected-active');
	row.siblings().removeClass('selected-active');
	if (typeof selflink != 'undefined') {
		var appointmentRequestDetailsViewContainer = $('#home .content-primary .prime'),
		appointmentRequestDetailsView;
		
		m.appointmentRequest = new m.AppointmentRequest();
		m.appointmentRequest.set('url', selflink);
		m.appointmentRequest.fetch({
			url : selflink,
			success: function(request) {
				appointmentRequestDetailsView = new m.AppointmentRequestDetailsView(
				{
					model : request,
					viewContainer : appointmentRequestDetailsViewContainer,
					allowProcess: m.allowProcess(request)
				});
				appointmentRequestDetailsView.render();
			},
			statusCode: {
				302 : function() {
					loginRedirect();
				}
			}
		});

	}
});


$('body .content-secondary').on('tap', '#submitted-select-options a', function(){
	var request = m.appointmentRequest,
        status = request.get("status"),
        form = $(this).find('.ui-btn-text').text();

	new m.ProcessRequestView(
	{
		model : request,
		arDetailCodes : m.addDetailCodes(request, form),
		viewContainer : $('#actions .content-secondary'),
		form: form
	}).render();

    $('#save-request').val($(this).attr('name'));
});

$('body').on('tap', '#process-request', function() {
	var url = m.appointmentRequest.get('url');
	var appointmentRequestInProcess = new m.AppointmentRequestInProcess();
	
	appointmentRequestInProcess.save({},{
		url: url + '/inprocess',
		error: function() {
			
		},
		success: function(model) {
			$.mobile.changePage( "#actions", { transition: "slidefade"} );
		},
		statusCode: {
			302 : function(){
				loginRedirect();
			},
			400 : function(){
				$('#appointmentRequestTable tr[data-selflink="'+url+'"]').trigger('tap');
			}
		}
	});
})
.on('click','#logout-btn',function() {
    var logoutUrl = m.resources.get('logout').get('href');
    $.ajax({
        url: m.resources.get('token').get('href'),
        type: 'DELETE',
        success: function(data){
            sessionStorage.clear();
            window.location = logoutUrl;
        }
    });
})
.on('pagebeforeshow','#actions',function() {
	var request = m.appointmentRequest,
	appointmentRequestDetailsViewContainer = $('#actions .content-primary .prime'),
	appointmentRequestDetailsView,
	processRequestViewContainer = $('#actions .content-secondary'),
	processRequestView,
	status = request.get("status"),
	form = m.chooseForm(status),
	detailCodes = m.addDetailCodes(request, form);
	
	appointmentRequestDetailsView = new m.AppointmentRequestDetailsView(
	{
		model : request,
		viewContainer : appointmentRequestDetailsViewContainer,
		allowProcess: false
	});
	processRequestView = new m.ProcessRequestView(
	{
		model : request,
		arDetailCodes : detailCodes,
		viewContainer : processRequestViewContainer,
		form: form
	});
		
	appointmentRequestDetailsView.render();
	processRequestView.render();

	var footerViewContainer = $('#actions-footer'), footerView;
	footerView = new m.FooterView({
		model : m.user,
		viewContainer : footerViewContainer
	});
	footerView.render();
	if (status == 'Submitted') {
		$('#save-request').val($('#submitted-select-options a.ui-btn-active').attr('name'));
	}
});

$('#actions .content-secondary').on('change', 'fieldset input[type="radio"]', function(){
	$(this).parents('.ui-field-contain').siblings('.ui-field-contain').find("input[type='radio']").checkboxradio("refresh");
	$('#save-request').button('enable');
});

$('#actions .content-secondary').on('tap', '#save-request', function(){
	var request = m.appointmentRequest,
		arDetailCode,
		status = this.value,
		isSecondAttempt = request.get('secondRequest'),
		selectedValue = $('#actions .content-secondary form').formParams();
		selectedChoice = $('#actions .content-secondary input:checked').attr('id');
		ardc = request.get('appointmentRequestDetailCode');


	if (selectedChoice.indexOf('Date') > 0) {
		var dateSelected = selectedChoice,
		timeSelected = 'optionTime' + dateSelected.slice(10);
		request.set({
			'appointmentDate' : request.get(dateSelected),
			'appointmentTime' : request.get(timeSelected)
		});
	}
	
	if (selectedValue.videoToPhone == "on") {
		switch (selectedValue.code) {
			case 'DETCODE1' :
				selectedValue.code = 'DETCODE10'
				break;
			case 'DETCODE2' :
				selectedValue.code = 'DETCODE11'
				break;
		}
	}

	arDetailCode = { userId: m.user.get('id'), detailCode: selectedValue };
	ardc.unshift(arDetailCode);
	
	request.save({
		id: request.get('dataIdentifier').uniqueId,
		status: status
	},{
		url: request.get('url'),
		error: function() {
			alert('error saving request');
			},
		success: function(model) {
			var appointmentRequestDetailsViewContainer = $('#home .content-primary .prime'),
			appointmentRequestDetailsView = new m.AppointmentRequestDetailsView(
			{
				model : model,
				viewContainer : appointmentRequestDetailsViewContainer,
				allowProcess: m.allowProcess(request)
			});
			
			appointmentRequestDetailsView.render();
			m.requestsTable.fnReloadAjax();
		},
		statusCode: {
			302 : function() {
				loginRedirect();
			}
		}
	});
});

$('body').on('tap', '#list-refresh-btn', function(){
	m.requestsTable.fnReloadAjax();
});


