define([
	//Paths from config.js, each passed into the following anonymous function
	'Global',
	'App',
	'Patient',
	'mainView',
	'footerView',
	'primaryHeaderView',
	'PatientSearchView',
	'sectionListView',
	'VitalSignsListView',
	'LabResultsView',
	'LabResultsInfoView',
	'MedView',
	'StaffUserDisclaimer',
    'PatientDetailsView',
	'User'
], function(Global, App, Patient, MainView, FooterView, PrimaryHeaderView, PatientSearchView, SectionListView, VitalSignsView,
		LabResultsView, LabResultsInfoView, MedView, staffUserDisclaimer, PatientDetailsView, user) {

	// http://documentcloud.github.com/backbone/#Router

    function displayPatientDetails() {
        new PatientDetailsView().render();
    }

	var AppRouter = Backbone.Router.extend({
		initialize: function() {
			$.mobile.autoInitializePage = false;
			this.title = App.defineResourceTitles().title;
			this.location = window.location.hash;
			Global.getUtilities().globalInit({user: user});
		},
		routes: {
			'': 'defaultAction',
			'patient-search': 'showPatientSearch',
			'summary': 'showSummary',
			'lab-results': 'showLabResults',
			'vital-signs': 'showVitalSigns',
			'medications': 'showMedications',
			'lab-results-information': 'showLabResultsInfo',
			'staff-user-disclaimer': 'showSUD',

			// Default
			'*actions': 'defaultAction'
		},

		//Pages
		showPatientSearch: function(e) {
            this.openPage(new PatientSearchView({patientDetailsSelected:displayPatientDetails}));
		},
		showSummary: function() {
			this.openPage(new SectionListView());
		},
		showLabResults: function() {
			this.openPage(new LabResultsView());
		},
		showLabResultsInfo: function() {
			this.openPage(new LabResultsInfoView());
		},
		showVitalSigns: function() {
			this.openPage(new VitalSignsView());
		},
		showMedications: function() {
			this.openPage(new MedView());
		},
		showSUD: function() {
			var url = window.location.pathname,
				redirectUrl = Global.getUtilities().getReferencePath() + '../staff-user-disclaimer/index.html?url=' + Global.getUtilities().getReferencePath();
			window.location = redirectUrl;
		},
		defaultAction: function(){
            this.showPatientSearch();
		},
		//route
		openPage: function(page){
			var redirectPath = 'patient-search',
				pageType = $(page.el).eq(0).attr('data-role');
			if (!Patient.instance().isValid() && page.id !== redirectPath) {
				this.location = '#'+redirectPath;
				return appRouter.navigate(redirectPath, {trigger: true});
			}

			if (pageType === 'dialog') {
				page.render();
				$.mobile.changePage("#" + page.id, {transition: 'pop'});
			} else {
				this.buildMain.call(this, page);
				this.activateFooter(Backbone.history.fragment);
				this.clearHeader();
				$('#main').animationComplete(function () {
					page.render();
					if ($('#content-primary').hasClass("closed")){
						Global.getUtilities().slidePrimary();
					}
				});
				$.mobile.changePage("#main", {allowSamePageTransition: true});
			}
		},
		clearHeader: function() {
			var primaryHeaderView = new PrimaryHeaderView();
			$('#content-primary').find(":jqmData(role='header')").empty().append(primaryHeaderView.render()).trigger('create');
		},
		activateFooter: function(page) {
			if (!page) {
				page = "patient-search";
			}
			$('#footer a, #footer-menu-popup li, #footer-menu-popup a').removeClass('ui-btn-active');
			$('#footer a[href="#'+ page +'"]').addClass('ui-btn-active');
			$('#footer-menu-popup a[href="#'+ page +'"]').parents('li').addClass('ui-btn-active');
		},

		buildMain: (_.once(function(page){
			$('body').append(new MainView().render());
		}))
	});

	var appRouter = new AppRouter(),
		eventAggregator = Global.getUtilities().eventAggregator;

	_.map(appRouter.routes, function(method, key) {
		eventAggregator.on(key, function() {
			appRouter.navigate('#'+key, {trigger: true});
		});
	});

	eventAggregator.on("footer", function() {
		$('#footer-menu-popup-popup, #footer-menu-popup-screen').remove();
		var $footer = $('#footer > .ui-navbar');

		var moreCount = 0,
			$footerList = $('>ul', $footer),
			count = $footerList.find('li').length;

		for (var i=0; i<count; i++) {
			var $footerListItem = $footerList.find('li:nth-child('+(i+1)+')'),
			realWidth = $footerListItem.width();
			$footerListItem.css('width','auto');
			var tempWidth = $footerListItem.width();
			if (realWidth > tempWidth) {
				moreCount++;
			}
		}

		var patient = Patient.instance(),
			footerView = new FooterView({patient: patient});

		var $generatedFooter = footerView.render(moreCount);
		if (!patient.isValid()) {
			$('li[data-requires-patient=true]', $generatedFooter).addClass('ui-disabled');
			$('#footer-menu-popup li[data-requires-patient=true]').addClass('ui-disabled');
		}

		var $footer = $('#footer'); 
		$footer.empty().append($generatedFooter);
		
		if (!$footer.find('div[data-role="navbar"]').hasClass('ui-navbar')) {
			try {
				$footer.trigger('create');
			} catch (err) {
				// JUSTIFICATION: Ignore error on trigger.  If the footer event is called around the same time, the trigger causes an error
			}
		}		
		
		$('#footer-menu-popup').removeAttr('style');
		appRouter.activateFooter(Backbone.history.fragment);
	});

	Backbone.history.start();
});