require.config({
	paths: {
		// path configuration assumes .js suffix

		// Libraries
		'jQuery': '../../js/libs/jquery-1.8.2.min',
		// custom version of jQM, see comments section in library for custom change log
		'jQM': '../../js/libs/jquery.mobile-1.2.0-CUSTOM',
		'Underscore': '../../js/libs/underscore-1.4.4.min',
		'JSON2': '../../js/libs/json2',
		'Backbone': '../../js/libs/backbone-1.0.min',
		'FormParams': '../../js/libs/jquery.formparams',
		'CalDateBox': '../../js/libs/jqm-datebox.comp.calbox.min-CUSTOM',
		'Global': '../../js/global',
		'HighCharts-default': '../../js/libs/highcharts',
		'HighCharts': '../../js/libs/highcharts-more',

		// Custom Helpers
		'jQMConfig': '../../js/libs/jqm-config', // Disables JQM Routing
		'Utilities': '../../js/utilities',
		'Modules': '../../modules/js/modules',
		'App': 'app',

		// Models
		'ResourceLink': '../../js/models/resourceLink',
		'User': '../../js/models/user',
		'MhpUser': '../../js/models/mhpUser',
		'UserSession': '../../js/models/userSession',
		'Patient': '../../modules/js/models/patient',
		'GraphLabResult': '../../modules/js/models/graphLabResult',
		'FooterButton': '../../js/models/footerButtonModel',
		'AppointmentFolder': '../../modules/js/models/appointmentFolder',
		'DetailedNote': '../../modules/js/models/detailedNote',
		'PastEventsListItem': '../../modules/js/models/pastEventListItem',
		'PastEvent': '../../modules/js/models/pastEvent',
		'HospitalEventListItem': '../../modules/js/models/hospitalEventListItem',
		'HospitalEvent': '../../modules/js/models/hospitalEvent',
		'TimeReport': '../../modules/js/models/timeReport',
		'TimeDetailedReport': '../../modules/js/models/timeDetailedReport',
		'VitalSignsTableRow': '../../modules/js/models/vitalSignsTableRow',
		'Radiology': '../../modules/js/models/radiology',
		'RadiologyDetails': '../../modules/js/models/radiologyDetails',
		'DateRange':'../../modules/js/models/dateRange',
		'Duration' : '../../modules/js/models/duration',
		'VitalsGraphPoint': '../../modules/js/models/vitalsGraphPoint',
		'LabGraphPoint': '../../modules/js/models/labGraphPoint',
		'MicrobiologyReport': '../../modules/js/models/microbiologyReport',
        'MicrobiologyDetailedReport': '../../modules/js/models/microbiologyDetailedReport',
		'Med': '../../modules/js/models/med',
		'MedDetails': '../../modules/js/models/medDetails',
		'MedFilter': '../../modules/js/models/medFilter',
		'Allergies': '../../modules/js/models/allergies',
		'ContactInformation': '../../modules/js/models/contactInformation',
		'MedicalDiagnoses': '../../modules/js/models/medicalDiagnoses',
		'Medications': '../../modules/js/models/medications',
		'Surgeries': '../../modules/js/models/surgeries',
		'StaffUserDisclaimer': '../../modules/js/models/staffUserDisclaimer',

		// Collections
		'Resources': '../../js/collections/resources',
		'GraphLabResultsByGroup': '../../modules/js/collections/graphLabResultsByGroup',
		'FooterButtons':'../../js/collections/footerButtons',
		'PastEventsList': '../../modules/js/collections/pastEventsList',
		'HospitalEventsList': '../../modules/js/collections/hospitalEventsList',
		'VitalSignsGraphData': '../../modules/js/collections/vitalSignsGraphData',
		'VitalSignsTable': '../../modules/js/collections/vitalSignsTable',
		'TimeReportsByGroup': '../../modules/js/collections/timeReportsByGroup',
		'RadiologyByRecent': '../../modules/js/collections/radiologyByRecent',
		'RadiologyByType':'../../modules/js/collections/radiologyByType',
		'Durations' : '../../modules/js/collections/durations',
		'LabGraphData': '../../modules/js/collections/labGraphData',
		'MicrobiologyReportsByGroup': '../../modules/js/collections/microbiologyReportsByGroup',
		'Meds': '../../modules/js/collections/meds',
		'Patients': '../../modules/js/collections/patients',


		// Views
		'mainView': '../../js/views/doubleColumnMainView',
		'footerView': '../../js/views/footerView',
		'secondaryView': '../../js/views/secondaryView',
		'secondaryHeaderView': '../../modules/js/views/secondaryHeaderView',
		'primaryView': '../../js/views/primaryView',
		'primaryHeaderView': '../../modules/js/views/primaryHeaderView',
		'SectionDetailsView': '../../modules/js/views/sectionDetailsView',
		'sectionListView': '../../modules/js/views/sectionListView',
		'pastEventDetailsView': '../../modules/js/views/pastEventDetailsView',
		'hospitalEventDetailsView': '../../modules/js/views/hospitalEventDetailsView',
		'VitalSignsListView': '../../modules/js/views/vitalSignsListView',
		'GraphView': '../../modules/js/views/graphView',
		'VitalSignsTableView': '../../modules/js/views/vitalSignsTableView',
		'PatientDetailsView': '../../modules/js/views/patientDetailsView',
		'RadiologyListView': '../../modules/js/views/radiologyListView',
		'RadiologyView': '../../modules/js/views/radiologyView',
		'RadiologyTabView': '../../modules/js/views/radiologyTabView',
		'RadiologyListContainerView': '../../modules/js/views/radiologyListContainerView',
		'RadiologyRecentListView': '../../modules/js/views/radiologyRecentListView',
		'RadiologyGroupedListView': '../../modules/js/views/radiologyGroupedListView',
		'RadiologyDetailsView': '../../modules/js/views/radiologyDetailsView',
		'detailsView': '../../modules/js/views/detailsView',
		'LabResultsView': '../../modules/js/views/labResultsView',
		'LabResultsInfoView': '../../modules/js/views/labResultsInfoView',
		'LabResultsListContainerView': '../../modules/js/views/labResultsListContainerView',
		'LabResultsGraphListView': '../../modules/js/views/labResultsGraphListView',
		'LabResultsTimeListView': '../../modules/js/views/labResultsTimeListView',
		'LabResultsTimeDetailsView': '../../modules/js/views/labResultsTimeDetailsView',
		'LabResultsMicroListView': '../../modules/js/views/labResultsMicroListView',
        'LabResultsMicroDetailsView': '../../modules/js/views/labResultsMicroDetailsView',
		'LabResultsTabView': '../../modules/js/views/labResultsTabView',
		'DrawChartView': '../../modules/js/views/drawChartView',
		'MedView': '../../modules/js/views/medView',
		'MedFilterView': '../../modules/js/views/medFilterView',
		'MedListView': '../../modules/js/views/medListView',
		'MedDetailsView': '../../modules/js/views/medDetailsView',
		'CustomDatePopup': '../../modules/js/views/customDatePopup',
		'PatientSearchView': '../../modules/js/views/patientSearchView',
		'eulaView': '../../modules/js/views/eulaView',

		// require js plugins
		'Text': '../../js/text'
    },
    waitSeconds: 90,
	shim: {
		'jQuery': {
			exports: '$'
		},
		'jQMConfig': {
			deps: ['jQuery']
		},
		'jQM': {
			deps: ['jQMConfig']
		},
		'HighCharts-default': {
			deps: ['jQuery']
		},
		'HighCharts': {
			deps: ['HighCharts-default']
		},
		'CalDateBox': {
			deps: ['jQM']
		},
		'FormParams': {
			deps: ['jQuery']
		},
		'Underscore': {
			exports: '_'
		},
		'Backbone': {
			deps: ['Underscore', 'CalDateBox', 'JSON2', 'FormParams'],
			exports: 'Backbone'
		},
		'Utilities': {
			deps: ['Backbone']
		},
		'Global': {
			deps: ['Backbone', 'Utilities']
		}
	}
});

require(['router']);
