define([],

	function() {
		var summaryItems = [];
		summaryItems.push(
			{title: 'Contact Information', target: 'summary-Contact-Information'},
			{title: 'Medical Diagnoses', target: 'summary-Medical-Diagnoses'},
			{title: 'Allergies', target: 'summary-Allergies'},
			{title: 'Inpatient Meds', target: 'summary-Inpatient-Medications'},
			{title: 'Outpatient Meds', target: 'summary-Outpatient-Medications'},
			{title: 'Surgeries', target: 'summary-Surgeries'}
		);

		var app = {

			title: 'Patient Viewer',
			id: 'patient-viewer', //match the app hash

			allergiesTitle					: 'patient-allergies-operational',
			contactInformationTitle			: 'patient-demographics-operational',
			medicationsTitle				: 'patient-medications-operational',
			medicationsDetailsTitle			: 'patient-medication-detail',
			medicalDiagnosesTitle			: 'patient-problems-operational',
			surgeriesTitle					: 'patient-surgeries-operational',

			graphLabResultsByGroupTitle		: 'patient-lab-tests-by-group-operational',
			microbiologyReportsByGroupTitle	: 'patient-lab-micro-tests-by-group-operational',
			presetDateRanges				: '../patient-viewer/data/durations.json',

			vitalsTableDataTitle			: 'patient-vitals-tabledata-operational',
			vitalsGraphDataTitle			: 'patient-vitals-graphdata-operational'
		};

		var constants = {
			tabs :{
				LAB_RESULTS_GRAPH_TAB	: 'Chem / Hem',
				LAB_RESULTS_MICRO_TAB	: 'Microbiology'
			}
		};

		return {
			assembleSummaryItems: function() {
				return summaryItems;
			},
			defineResourceTitles: function() {
				return app;
			},
			getConstants: function() {
				return constants;
			}
		};
	}
);