define([
    'Global',
    'headerView',
    'DateFormatJS',
    'QuestionResponses',
    'Text!../html/panes/summary.html'
],
    function (Global, HeaderView, DateFormatJS, QuestionResponses, summaryTemplate) {
        "use strict";
        return Backbone.View.extend({
            id: 'summary',
            tagName: 'div',
            className: 'alpha',

            initialize: function (details) {
                this.summaryTemplate = _.template(summaryTemplate);
                this.details = new QuestionResponses().getBaselines(details);
            },

            render: function () {
                var details = this.details;

                $.extend(
                    details,
                    {
                        user: this.getUser(),
                        timestamp: this.timestamp()
                    }
                );

                $("#content")
                    .empty()
                    .append(
                        this.$el
                            .empty()
                            .append(this.summaryTemplate(details))
                    )
                    .trigger('create');

                new HeaderView()
                    .render({
                        title: 'Summary',
                        leftAction: {
                            id: 'home',
                            href: '#home',
                            text: 'MyStory'
                        },
                        rightAction: {
                            id: 'pdf-summary',
                            href: "#pdf",
                            text: 'PDF'
                        }
                    });

                $(window).scrollTop(0);
            },

            getUser: function () {
                return $('#footer-username').clone().find('span').remove().end().text().trim().split(', ').reverse().join(" ");
            },

            timestamp: function () {
                var time = new Date().format();
                time = time.split(':');
                time.pop();
                time = time.join('');
                time = time.split(' ');
                time[0] = time[2];
                time[2] = time[3];
                time[3] = "@";

                return time.join(' ');
            }
        });
    }
);