define([
	'Global',
	'headerView',
	'Text!../html/panes/subnav.html',
	'QuestionResponses'
	],
	function(Global, HeaderView, subNavTemplate, QuestionResponses) {
		"use strict";
        return Backbone.View.extend({
			id: 'subnav-view',
			tagName: 'div',
			className: 'alpha',

			initialize: function(details) {
				this.template  = _.template(subNavTemplate);
                this.details = new QuestionResponses().getBaseline(details);
			},

			render: function() {
                var details = this.details;

                new HeaderView().render({
					title: details.title,
					leftAction: {
						id: 'home',
						href: '#home',
						text: 'MyStory'//MyGoals.CONSTANTS.APP_NAME
					}
				});
				
				$("#content")
					.empty()
					.append(
						this.$el
							.empty()
							.append(
								this.template(details)
							)
					)
					.trigger('create');

				$(window).scrollTop(0);
			}
		});
	}
);
