define(
	[
		'Global',
		'UserSession',
		'headerView',
		'Text!../html/panes/nav.html',
		'QuestionResponses'
	],
	function(Global, UserSession, HeaderView, navTemplate, QuestionResponses) {
		"use strict";
        return Backbone.View.extend({
			id: 'nav',
			tagName: 'div',
			className: 'alpha',

			initialize: function() {
				this.navTemplate  = _.template(navTemplate);
				this.details = {
					categories: [{
						inventoryType: "REFLECTIONS",
						id: "reflection",
						title: "My Reflections",
						maxdate: "",
						progress: 0,
						total: 4
					}, {
						inventoryType: "FEELINGS",
						id: "feel",
						title: "How I Feel",
						maxdate: "",
						progress: 0,
						total: 3
					}, {
						inventoryType: "CURRENT_AND_DESIRED_STATE",
						id: "desire",
						title: "What I Want",
						maxdate: "",
						progress: 0,
						total: 10
					}, {
						inventoryType: "PRIORITIES",
						id: "priorities",
						title: "Priorities",
						maxdate: "",
						progress: 0,
						total: 2
					}]
				};
			},

			render: function() {
				var questionResponses,
					details = this.details,
					referencePath = Global.getUtilities().getReferencePath(),
					$logout = $("#footer-logout-btn"),
					href = $logout.attr('href') + '?redirect_uri=',
					inOrOut = $logout.text().trim(),
					userSession = new UserSession();
				
				if ( $('#footer-username').text().indexOf('Logged in as') >= 0 && userSession.get('mhpuser').rightOfAccessAccepted) {
					questionResponses = new QuestionResponses();
					for (var i=0; i<details.categories.length; i++) {
						details.categories[i] = $.extend({},
							details.categories[i],
							{
								maxdate: questionResponses.maxDateOfType(details.categories[i].inventoryType),
								progress: questionResponses.numberOfType(details.categories[i].inventoryType)
							}
						);
					}
				}

				new HeaderView()
					.render({
						title: 'MyStory'
					});

				$("#content")
					.empty()
					.append(
						this.$el
							.empty()
							.append(
								this.navTemplate(details)
							)
					)
					.trigger('create');

				if(inOrOut==="Logout") {
					$logout.attr('href', href + referencePath);
				}
				else {
					$logout.attr('href', href.replace('logout','oauthlogin') + referencePath);
				}
				$(window).scrollTop(0);
			},

			events: {
				//"tap #btnLearn": "openLearn"
			},

			prettyDate: function(time) {
				var date = time,
					diff = (((new Date()).getTime() - date.getTime()) / 1000),
					day_diff = Math.floor(diff / 86400);

				if ( isNaN(day_diff) || day_diff < 0 || day_diff >= 31 )
					return formatDateToDays(time);
				return day_diff == 0 && (
						diff < 60 && "just now" ||
						diff < 120 && "1 minute ago" ||
						diff < 3600 && Math.floor( diff / 60 ) + " minutes ago" ||
						diff < 7200 && "1 hour ago" ||
						diff < 86400 && Math.floor( diff / 3600 ) + " hours ago") ||
					day_diff == 1 && "Yesterday" ||
					day_diff < 7 && day_diff + " days ago" ||
					day_diff < 31 && Math.ceil( day_diff / 7 ) + " weeks ago";
			},

			PassLoginCheck: function(trigger){
				//Possibly may want to check for HTTPS
				//Should check go to target not mygoals... baby steps
				if ($('#footer-username').html().indexOf('Logged in as') > 0)
					Global.getUtilities().eventAggregator.trigger(trigger);
				else
					window.location = Global.getUtilities().getReferencePath() + '../oauthlogin?redirect_uri=' + Global.getUtilities().getReferencePathWithHash();
			},

			openSecure: function(e){
				e.preventDefault();
				this.PassLoginCheck(e.currentTarget.href.split('#')[1]);
			},

			openLearn: function(e){
				e.preventDefault();
				Global.getUtilities().eventAggregator.trigger("goToLearn");
			}
		});
	}
);
