define([
    'Global',
    'footerView',
    'Text!../html/templates/common/main.html',
    'Confirm'
],
    function (Global, FooterView, mainTemplate, Confirm) {
        'use strict';
        var view,
            mainView = Backbone.View.extend({
            el: $('#main'),

            initialize: function () {
                this.mainTemplate = _.template(mainTemplate);
                view = this;
            },

            render: function () {
                this.$el
                    .append(this.mainTemplate)
                    .find("#footer")
                    .append(new FooterView().render())
                    .find('a:not([href="#about"])');
                Global.getUtilities().create(this.$el);

            },

            events: {
                "tap footer a:not([href='#about']), .go-back": "LeftWithoutSave"
            },

            fails: function ($req) {
                var failMsg = "";
                $req.each(function () {
                    if (this.value.trim() === "") failMsg += "<p>" + $('label[for="' + this.id + '"]').text() + "</p>";
                });

                return failMsg;
            },

            redirect: function (path) {
                //Was added to ensure always clear patient on logging out from MyStory
                //regardless of IE9 browser cache settings. auto-cleared on modern browsers.
                if (path.match('logout')) {
                    require(['Patient'], function (Patient){
                        Patient.clearInstance();
                    });
                }
                window.location = path;
            },

            LeftWithoutSave: function (e) {
                var path = e.currentTarget.href,
                    $updated = $('input[data-updated],textarea[data-updated],.reasons[data-updated],select[data-updated]'),
                    $required = $('.ui-slider-input, textarea, select.priority, input.priority').not('.ignore'),
                    failsRequired = view.fails($required),
                    details = {
                        'title': 'Exit Confirmation',
                        'class': 'confirm-msg',
                        'message': 'You have unsaved changes, confirm action below:',
                        'buttons': {
                            'Exit [No Save]': {
                                'class': 'ui-btn ui-shadow ui-btn-corner-all ui-btn-inline ui-btn-up-e',
                                'action': function () {
                                    view.redirect(path);
                                    $('footer .ui-btn-active').removeClass('ui-btn-active');
                                }
                            },
                            'Cancel': {
                                'class': 'ui-btn ui-shadow ui-btn-corner-all ui-btn-inline ui-btn-up-e',
                                'action': function () {
                                    $('footer .ui-btn-active').removeClass('ui-btn-active');
                                }
                            },
                            'Save': {
                                'class': 'ui-btn ui-shadow ui-btn-corner-all ui-btn-inline ui-btn-up-e',
                                'action': function () {
                                    $('#btn-save')
                                        .data('path', path)
                                        .trigger('tap');

                                    //window.location = path;
                                    $('footer .ui-btn-active').removeClass('ui-btn-active');
                                }
                            }
                        }
                    };

                if ($updated.length) {
                    if (failsRequired) {
                        delete details['buttons']['Save'];
                        details['message'] = '<p>Required answer(s) to save:</p>' + failsRequired + details['message'];
                    }
                    $.confirm(details);
                    return false;
                } else {
                    setTimeout(function () {
                        $('footer .ui-btn-active').removeClass('ui-btn-active');
                    }, 300);
                    //necessary because global FooterView hijacks all links in footer
                    view.redirect(path);
                }
            }
        });

        return new mainView();
    }
);