define([
	'Global',
	'headerView',
	'Text!../html/panes/learn.html'
	],
	function(Global, HeaderView, learnTemplate ) {
		var LearnView = Backbone.View.extend({
			id: 'learn',
			tagName: 'div',
			className: 'alpha',

			//Slider Variables
			self: this,
			pixelsBeforeTriggerChange: 50,
			$slides :null,
			$slidesInner :null,     
			$slider :null,   
			itemWidth :300,
			$body :null,
			scrollDuration : 200,
			startDragPosition : false,
			startScrollPosition :0,
			startScrollPositionY :0,
			ua : navigator.userAgent.toLowerCase(),

			initialize: function() {
				this.learnTemplate  = _.template(learnTemplate);
				this.isAndroid = this.ua.indexOf("android") > -1;
				this.isIphone =  this.ua.indexOf("iphone") > -1;
				this.isWin8 = window.navigator.msPointerEnabled;
			},

			render: function() {
				$("#content")
					.empty()
					.append(
						this.$el
							.empty()
							.append(this.learnTemplate())
							.append( "<div id='output' class='alpha'></div>")
					)
					.trigger('create');

				$slides = $('.slides article');
				$slidesInner = $('.slides ');
				$slider = $('.slider');
				itemWidth = $slider.width();
				$body = $('body');

				new HeaderView()
					.render({
						title: 'Learn',
						leftAction: {
							id: 'home',
							href: '#home',
							text: 'MyStory'
						},
						rightAction: {
							id: 'PDF',
							href: 'pdf/Components of Health and Well_Being Popup Diagram.pdf',
							text: 'PDF'
						}
					});
			},

			events: {
				'tap .controls label':'labelTap',
				'tap .active label' : 'activeSlide',
				//ms events
				// 'swipeleft .slider' : "msSwipeLeft",
				// 'swiperight .slider' : "msSwipeRight",
				// 'MSPointerDown .slider':'startDrag', // this does not have a start pos
				// 'MSPointerUp .slider':'stopDrag',
				// 'MSPointerOut .slider':'stopDrag',
				//everything else
				//'touchstart .slider':'startDrag',
				//'touchend .slider':'stopDrag',
				//'touchcancel .slider':'stopDrag'
			},
			goToSlide: function(backOrNext)
			{
				var $slides = $('.slides article'),
						index =  $('.slides article.selected').index(),
						slidesLength = $slides.length;
				if( backOrNext === "next" )
				{// #back
					index = Math.floor((index+1) %  slidesLength);
				}
				else
				{// #next
					index = (index <= 0)?(slidesLength-1):(index-1);
				}

				$slides.removeClass('selected')
					.eq(index )
							.addClass('selected');

				$('.active label').removeClass('selected')
					.eq(index )
							.addClass('selected');
				
				$(window).scrollTop(0);
			},
			msSwipeLeft:function(e){
				e.stopPropagation();
				console.log('swipeleft');
				//if( this.isWin8 )
					this.goToSlide('prev');
			},
			msSwipeRight:function(e){
				e.stopPropagation();
				e.preventDefault();
				console.log('msSwipeRight');
				//if( this.isWin8 )
					this.goToSlide('next');
			},
			labelTap:function(event){
				var direction =
						event.currentTarget.getAttribute('class').indexOf('next') !== -1?'next': 'prev',
					self = this;

				$slidesInner.animate({
						//'left':0,
						'marginLeft': (direction=="next")?(-1*self.itemWidth):self.itemWidth
					}, self.scrollDuration,
					function(){
						if( direction )
							self.goToSlide ( direction );
						$(this).css({'marginLeft': 0});
					});
			},
			activeSlide: function(event) {
				var $labels = $('.active label'),
					index =$labels.index(event.currentTarget),
					$slides = $('.slides article');
				$slides
					.removeClass('selected')
					.eq(index)
							.addClass('selected');
				$labels
					.removeClass('selected')
					.eq(index)
							.addClass('selected');
			},
			startDrag: function ( event ) {
				if( event.srcElement.className.indexOf("ui-btn") >-1 ||
					event.srcElement.className.indexOf("ui-icon") >-1 )
					return;
				if(this.isAndroid || this.isIphone) event.preventDefault();
				var w = $slidesInner.width(),
					self = this;
				this.startScrollPosition = $body.scrollTop();
				this.startDragPosition = event.pageX || event.originalEvent.touches[0].pageX || event.originalEvent.changedTouches[0].pageX;
				this.startDragPositionY = event.pageY || event.originalEvent.touches[0].pageY || event.originalEvent.changedTouches[0].pageY;

				$slidesInner.css({ 'width':w+"px"});
				$slider.on((window.navigator.msPointerEnabled)?'MSPointerMove':'touchmove',
					function( e ) {
						if(self.isAndroid||self.isIphone) $body.scrollTop(($body.scrollTop()+ self.startScrollPosition + self.startDragPositionY -
								(e.pageY || e.originalEvent.touches[0].pageY || e.originalEvent.changedTouches[0].pageY))/2);
						$slidesInner.css({
							'marginLeft': -(
								self.startDragPosition -
								(e.pageX || e.originalEvent.touches[0].pageX || e.originalEvent.changedTouches[0].pageX)
							)
						});
					}
				);
			},
			stopDrag: function ( event ) {
				//event.preventDefault();

				var self = this,
					direction = false;
				$slider.off((window.navigator.msPointerEnabled)?'MSPointerMove':'touchmove');
				if ( this.startDragPosition ) { //event.pageX  ||
					var currentDragPosition =  event.originalEvent.changedTouches[0].pageX,
						moveDirection = 0;
					if ( this.startDragPosition + this.pixelsBeforeTriggerChange < currentDragPosition ) {
						direction = 'prev';
						moveDirection = 1;
					} else if ( this.startDragPosition - this.pixelsBeforeTriggerChange > currentDragPosition ) {
						direction = 'next';
						moveDirection = -1;
					}
					$slidesInner.animate({
							'marginLeft': this.itemWidth * moveDirection
						}, this.scrollDuration,
						function(){
							$slidesInner.css({ 'width':"",'marginLeft': 0});
							if( direction )
							{ self.goToSlide(direction); }
						});
				}
				startDragPosition = false;
			}
		});

		return LearnView;
	}
);
