define([
	'Global',
	'Confirm',
	'Inventory',
	'Text!../html/templates/common/header.html'
	],
	function(Global, Confirm, Inventory, header) {
        "use strict";
		return Backbone.View.extend({
			initialize: function () {
				this.template = _.template(header);
			},

			render: function(details) {
				$('#header')
					.empty()
					.append(
						this.$el
							.empty()
							.append(this.template(details))
					)
					.trigger('create');

				$(window).scrollTop(0);
			},

			events: {
				"tap #pdf-summary-btn": "printPDF"
			},

			printPDF: function(e){
				e.preventDefault();
				window.open(Inventory.instance().get('report').href, "_blank");
			}

		});
	}
);
