define([
	'Global',
	'Text!../html/templates/common/about.html'
	],
	function(Global, aboutTemplate) {
        'use strict';
		return Backbone.View.extend({
			id: 'about',
			attributes: {'data-role': 'dialog'},
			initialize: function() {
                this.$page = $('.alpha');
                this.$body = $('body');
                this.$aboutBtn = $('#footer-about-btn');
				this.compiledTemplate = _.template(aboutTemplate);
			},
			render: function() {
                this.$page.hide();
                this.$body.append(
                    this.$el.empty().append(this.compiledTemplate())
                );
			},
			events: {
				'tap a[title="Close"]': "home"
			},
			home: function(e) {
				e.preventDefault();
                this.$page.show();
                this.$aboutBtn.removeClass('ui-btn-active');
				history.back();
			}
		});
	}
);