define([
    'Global',
    'mainView',
    'navView',
    'aboutView',
    'summaryView',
    'learnView',
    'formView',
    'Questions',
    'subNavView',
    'eulaView',
    'UserSession'

], function (Global, mainView, NavView, AboutView, SummaryView, LearnView, FormView, Questions, SubNavView, EulaView, UserSession) {
    "use strict";
    // http://documentcloud.github.com/backbone/#Router
    var appRouter, view,
        eventAggregator = Global.getUtilities().eventAggregator,
        AppRouter = Backbone.Router.extend({
            initialize: function () {
                view = this;
                this.userSession = new UserSession();
                this.userLoggedIn = this.userSession.isLoggedIn();
                var app = { user: ''},
                    eulaHTML = new EulaView().template.call();

                if (this.userLoggedIn) {
                    app.user = this.userSession.get('mhpuser');
                }
                Global.getUtilities().globalInit(app);

                this.title = "MyStory";
                this.initialLoad = true;
                this.location = window.location.hash;
                this.eulaModifiedDate = $('#modified-date', eulaHTML).text();
                window.location.hash = Global.getUtilities().checkEULA(window.location.hash, this.eulaModifiedDate);
            },

            routes: {
                'about': 'showAboutPage',
                'learn': 'showLearnPage',
                'summary': 'showSummaryPage',
                'desire/:id': 'getDesire',
                'desire' : 'showDesirePage',
                'feel': 'showFeelPage',
                'home': 'showMainPage',
                'reflection/:id': 'getReflection',
                'reflection': 'showReflectionPage',
                'priorities': 'showPrioritiesPage',
                'eula': 'showEulaPage',

                // Default
                '*actions': 'defaultAction'
            },

            questions: function () {
                return new Questions().details;
            },

            //Pages
            defaultAction: function () {
                appRouter.navigate('#home', {trigger: true});
                window.location.hash = "home";
            },

            showAboutPage: function () {
                view.openPage(new AboutView());
            },

            showEulaPage: function () {
                view.openPage(
                    new EulaView({
                        location: this.location,
                        destination: 'clear'
                    })
                );
            },

            requestUserLogin: function () {
                window.location = referencePath + '../oauthrequestUserLogin?redirect_uri=' + Global.getUtilities().getReferencePath();
            },

            showMainPage: function () {
                view.openPage(new NavView());
            },

            showLearnPage: function () {
                view.openPage(new LearnView());
            },

            showFeelPage: function () {
                this.showDetails('feelings');
            },

            showSubNav: function (category) {
                view.openPage(new SubNavView(view.questions()[category]));
            },

            showDesirePage: function () {
                this.showSubNav('desired');
            },

            showReflectionPage: function () {
                this.showSubNav('reflections');
            },

            showDetails: function (category) {
                view.openPage(new FormView(view.questions()[category]))
            },

            showPrioritiesPage: function () {
                this.showDetails('priorities');
            },

            showSummaryPage: function () {
                view.openPage(new SummaryView(view.questions()));
            },

            getQuestionByCategoryAndId: function (category, id) {
                //If bookmarked and not logged in prompt login
                if (!this.userLoggedIn) { this.requestUserLogin(); }

                var obj = $.extend({}, this.questions()[category]);

                obj.questions = obj.questions[id-1];
                obj.title = obj.questions.title;

                view.openPage(new FormView(obj));
            },

            getReflection: function (id) {
                this.getQuestionByCategoryAndId('reflections', id);
            },

            getDesire: function (id) {
                this.getQuestionByCategoryAndId('desired', id);
            },

            activateFooter: function (page) {
                $('#footer a, #footer-menu-popup li, #footer-menu-popup a').removeClass('ui-btn-active');
                $('#footer-menu-popup a[href="#' + page + '"]').parents('li')
                    .add('#footer a[href="#' + page + '"]')
                    .addClass('ui-btn-active');
            },

            openPage: function (page) {
							var pageType = $(page.el).eq(0).attr('data-role'),
								location = window.location.hash,
								eulaCheck = Global.getUtilities().checkEULA(window.location.hash, this.eulaModifiedDate);

							if (eulaCheck !== location){
								appRouter.navigate('#eula', {trigger: true});
							} else if (pageType === 'dialog') {
								page.render();
								$.mobile.changePage("#" + page.id, {transition: 'pop'});
							} else {
								this.buildMain.call(this, page);
								$('#main').animationComplete(function () {
									page.render();
								});
								$.mobile.changePage("#main", {allowSamePageTransition: true});
							}
            },

            buildMain: (_.once(function (page) {
                $('body').append(mainView.render());
                page.render(true);
            }))
        });

    appRouter = new AppRouter();
    //Global.getUtilities().parseTokenAndRegisterOauthHandler();

    _.map(appRouter.routes, function (method, key) {
        eventAggregator.on(key, function () {
            appRouter.navigate('#' + key, {trigger: true});
        });
    });

    Backbone.history.start();
});
