define(
	['QuestionResponses'],
	function(QuestionResponses) {
		var Questions = Backbone.Model.extend({
			defaults: {},
			initialize: function() {
				var questionResponses = new QuestionResponses();
				this.details = {
					reflections: {
						inventoryType: 'REFLECTIONS',
						title: 'Reflections',
						leftAction: {
							id: 'reflection',
							href: '#reflection',
							text: 'Reflections'
						},
						questions: [{
							href:'#reflection/1', title: 'What Matters',
							question: "What REALLY matters to you in your life?",
							id: "reflection-matters"
						},
						{
							href:'#reflection/2', title: 'Sense of Joy',
							question: "What brings you a sense of joy and happiness?",
							id: "reflection-joy"						},
						{
							href:'#reflection/3', title: 'Sorrow',
							question: "What brings you a sense of sadness or sorrow?",
							id: "reflection-sorrow"
						},
						{
							href:'#reflection/4', title: 'Vision',
							question: "What is your vision of your best possible health? How would you like to feel and look? What activities would you like to be able to do?",
							id: "reflection-vision"
						}]
					},
					desired: {
						inventoryType: 'CURRENT_AND_DESIRED_STATE',
						title: 'What I Want',
						leftAction: {
							id: 'desire',
							href: '#desire',
							text: 'Desire'
						},
						questions: [{
							id: "body",
							href:'#desire/1', title: "Working the Body", quote: "Energy and Flexibility",
							states: [{
								state: "Current",
								label: "List the reasons you chose this number."
							}, {
								state: "Desired",
								label: "What changes could you make to help you get there?"
							}],
							question: "Movement and physical activities like walking, dancing, gardening, sports, lifting weights, yoga, cycling, swimming, and working out in a gym."
						},
						{
							id: "recharge",
							href:'#desire/2', title: "Recharge", quote: "Rest and Sleep",
							states: [{
								state: "Current",
								label: "List the reasons you chose this number."
							}, {
								state: "Desired",
								label: "What changes could you make to help you get there?"
							}],
							question: "Getting enough rest and sleep and participating in activities that help you feel recharged and fueled."
						},
						{
							id: "fuel",
							href:'#desire/3', title: "Food and Drink", quote: "Nourish and Fuel",
							states: [{
								state: "Current",
								label: "List the reasons you chose this number."
							}, {
								state: "Desired",
								label: "What changes could you make to help you get there?"
							}],
							question: "Eating healthy well-balanced meals with plenty of fruits and vegetables each day. Drinking enough water and limiting sodas, sweetened drinks, and alcohol."
						},
						{
							id: "life",
							href:'#desire/4', title: "Personal Development", quote: "Personal life and Work life",
							states: [{
								state: "Current",
								label: "List the reasons you chose this number."
							}, {
								state: "Desired",
								label: "What changes could you make to help you get there?"
							}],
							question: "Learning and growing. Developing abilities and talents. Balancing responsibilities where you live, volunteer, and work."
						},
						{
							id: "family",
							href:'#desire/5', title: "Family, Friends, and Co-Workers", quote: "Hearing and Being Heard",
							states: [{
								state: "Current",
								label: "List the reasons you chose this number."
							}, {
								state: "Desired",
								label: "What changes could you make to help you get there?"
							}],
							question: "Having caring and supporting relationships where you feel heard and connected to the people you love and care about. The quality of your communication with family, friends and your co-workers."
						},
						{
							id: "soul",
							href:'#desire/6', title: "Spirit and Soul", quote: "Growing and Connecting",
							states: [{
								state: "Current",
								label: "List the reasons you chose this number."
							}, {
								state: "Desired",
								label: "What changes could you make to help you get there?"
							}],
							question: "Having a sense of purpose and meaning in your life. Feeling connected to something larger than yourself. Finding strength in difficult times. This may include your faith or religion, meaningful community organizations, or other sources of comfort and strength like music, nature, or the arts."
						},
						{
							id: "surroundings",
							href:'#desire/7', title: "Surroundings", quote: "Physical and Emotional",
							states: [{
								state: "Current",
								label: "List the reasons you chose this number."
							}, {
								state: "Desired",
								label: "What changes could you make to help you get there?"
							}],
							question: "Feeling safe and having comfortable, healthy spaces where you work and live. The quality of the lighting, color, air, and water. Decreasing unpleasant clutter, noises, and smells"
						},
						{
							id: "mind",
							href:'#desire/8', title: "Power of the Mind", quote: "Strengthen and Listen",
							states: [{
								state: "Current",
								label: "List the reasons you chose this number."
							}, {
								state: "Desired",
								label: "What changes could you make to help you get there?"
							}],
							question: "Tapping into the power of your mind to heal and cope. Listening to your inner thoughts, paying attention, and noticing. Using mind-body techniques like relaxation, breathing, biofeedback, or guided imagery."					},
						{
							id: "prevention",
							href:'#desire/9', title: "Prevention Care",
							states: [{
								state: "Current",
								label: "List the reasons you chose this number."
							}, {
								state: "Desired",
								label: "What changes could you make to help you get there?"
							}],
							question: "Being up to date on vaccines (e.g. flu, pneumonia, and shingles shots). Getting recommended cancer screenings (PAP smear, colonoscopy, mammogram) and blood tests (cholesterol). Not smoking and avoiding second hand smoke. Wearing seat belts. Limiting alcohol use. Use of nutritional supplements and complementary therapies."
						},
						{
							id: "intervention",
							href:'#desire/10', title: "Medical Treatment",
							states: [{
								state: "Current",
								label: "List the reasons you chose this number."
							}, {
								state: "Desired",
								label: "What changes could you make to help you get there?"
							}],
							question: "If you are under the care of a healthcare professional, understanding your treatment plan and how to take your medications. Asking questions when you don't understand your treatment plan or the plan doesn't fit with what matters to you. Use of vitamins and supplements. Use of complementary therapies."
						}]
					},
					feelings: {
						inventoryType: "FEELINGS",
						title: 'How I Feel',
						leftAction: {
							id: 'home',
							href: '#home',
							text: 'MyStory'
						},
						questions: [{
							id: "feelings-physically",
							title: "Physically, I currently feel...",
							mintext: "Miserable (pain, weak, drained)",
							maxtext: "Great (high-energy, strong, fit)"
						}, {
							id: "feelings-mentally",
							title: "Mentally, I currently feel...",
							mintext: "Miserable (anxious,angry, hopeless, alone)",
							maxtext: "Great (happy, hopeful, connected, content)"
						}, {
							id: "feelings-day-to-day",
							title: "Day-to-day, to live my life, it is...",
							mintext: "Miserable (very hard, exhausting)",
							maxtext: "Great (easy, fulfilling)"
						}]
					},
					priorities : {
						inventoryType: 'PRIORITIES',
						title: 'My Priorities',
						leftAction: {
							id: 'home',
							href: '#home',
							text: 'MyStory'
						},
						questions: [{
							id: "priority1",
							title: "Priority 1"
						}, {
							id: "priority2",
							title: "Priority 2"
						}],
						categories: [{
							area: 'Working My Body',
							goals: [
								'Talk with my VA team about increasing my activity level'
							]
						},
						{
							area: 'My Surroundings',
							goals: [
								'Create a relaxing space',
								'Clean up clutter'
							]
						},
						{
							area: 'My Personal Development',
							goals: [
								'Sign up to volunteer',
								'Go to school',
								'Learn a hobby',
								'Get a job'
							]
						},
						{
							area: 'My Food and Drink',
							goals: [
								'Eat more fruit and vegetables',
								'Cut down on portion sizes',
								'Join the MOVE weight management program'
							]
						},
						{
							area: 'My Relationships',
							goals: [
								'Join a support group',
								'Make a new friend'
							]
						},
						{
							area: 'Spirit and Soul',
							goals: [
								'Practice being thankful',
								'Let go of my grudges',
								'Start a journal'
							]
						},
						{
							area: 'Power of the Mind',
							goals: [
								'Practice paying attention',
								'Learn a breathing exercise to slow down',
								'Download the Breathe 2 Relax mobile app'
							]
						},
						{
							area: 'My Health Care',
							goals: [
								'Make sure I understand my treatment plan',
								'Get my vaccinations',
								'Take my medication every day'
							]
						}]
					}
				};
			}
		});
		//always need latest updatedDate and newest baseline
		return Questions;
	}
);
