require.config({
	paths: {
		// path configuration assumes .js suffix

		// Libraries
		//'jQuery': 'https://ajax.googleapis.com/ajax/libs/jquery/1.9.1/jquery.min.js',
		'jQuery': '../../js/libs/jquery-1.8.2.min',
		// custom version of jQM, see comments section in library for custom change log
		'jQM': '../../js/libs/jquery.mobile-1.2.0-CUSTOM',
		//'jQUI': '../../js/libs/jquery-ui-1.8.24.dev.min',
		// 'Modernizr': '../../js/libs/modernizr.custom',
		'Underscore': '../../js/libs/underscore-1.4.4.min',
		'JSON2': '../../js/libs/json2',
		'Backbone': '../../js/libs/backbone-1.0.min',
		'FormParams': '../../js/libs/jquery.formparams',
		'Confirm': '../../js/libs/jquery.confirm',
		'DateFormatJS': '../../js/libs/date.format',
		'Chained': '../../js/libs/jquery.chained',
		'MyGoals': 'mygoals',
		'Global': '../../js/global',

		// Custom Helpers
		'jQMConfig': '../../js/libs/jqm-config', // Disables JQM Routing
		'Utilities': '../../js/utilities',

		// Models
		'ResourceLink': '../../js/models/resourceLink',
		'MhpUser': '../../js/models/mhpUser',
		'FooterButton': '../../js/models/footerButtonModel',
		'User': '../../js/models/user',
		'UserSession': '../../js/models/userSession',
		'Patient': '../../js/models/patient',
		'Inventory': 'models/inventory',
		'InventoryResponse': 'models/inventoryResponse',
		'QuestionResponse': 'models/questionResponse',
		'Questions': 'models/questions',


		// Collections
		'Resources': '../../js/collections/resources',
		'FooterButtons':'../../js/collections/footerButtons',
		'InventoryResponses': 'collections/inventoryResponses',
		'QuestionResponses': 'collections/questionResponses',

		// Views
		'mainView': 'views/mainView',
		'headerView': 'views/headerView',
		'footerView': '../../js/views/footerView',
		'navView' : 'views/navView',
		'aboutView': 'views/aboutView',
		'formView': 'views/formView',
		'learnView': 'views/learnView',
		'summaryView': 'views/summaryView',
		'subNavView': 'views/subNavView',
		'prioritiesView': 'views/prioritiesView',
		'eulaView': '../../modules/js/views/eulaView',

		// require js plugins
		'Text': '../../js/text'
    },
    waitSeconds: 30,
	shim: {
		'jQuery': {
			exports: '$'
		},
		'jQMConfig': {
			//deps: ['jQUI'] // use jQUI as dependency if jQUI is required.  see https://github.com/jquery/jquery-mobile/issues/5119
			deps: ['jQuery']
		},
		'jQM': {
			deps: ['jQMConfig']
		},
		'FormParams': {
			deps: ['jQuery']
		},
		'Confirm': {
			deps: ['jQuery']
		},
		'Underscore': {
			exports: '_'
		},
		'Backbone': {
			deps: ['Underscore', 'jQM', 'JSON2', 'FormParams'],
			exports: 'Backbone'
		},
		'Utilities': {
			deps: ['Backbone']
		},
		'Global': {
			deps: ['Backbone', 'Utilities']
		},
	}
});

require(['router']);
