define([
	'Global',
	'VitalSignsTable',
	'Text!../../modules/html/templates/panes/vitalsTable.html',
	'Text!../../modules/html/templates/panes/vitalsTableRow.html'
],
	function(Global, VitalSignsTable, tableTemplate, tableTemplateRow){
		var VitalSignsTableView = Backbone.View.extend({
			tagName: 'div',
			id: 'vital-sign-table',
			initialize: function(){
				this.tableTemplate = _.template(tableTemplate);
				this.rowTemplate = _.template(tableTemplateRow);
			},
			render: function(url){
				var tableTemplate = this.tableTemplate,
					rowTemplate = this.rowTemplate,
					container = $(this.el),
					tableContent;

				container.empty();
				container.append(tableTemplate({title: "Vital Signs", tableID: "vitals-table"}));

				var primaryContent = new VitalSignsTable();

				primaryContent.fetch({
					async: false,
					url: url,
					success: function(){
						$("table tbody tr", container).last().remove();
						tableContent = primaryContent.toJSON().vitalTableRow;

						$(primaryContent.models).each(function(){
							$("table tbody", container).append(rowTemplate(this.toJSON()));
						});

						$("table tbody", container).find("tr:odd").addClass("odd");
						$("table tbody", container).find("tr:even").addClass("even");
					}
				});
				return container;
			}

		});
		return VitalSignsTableView;
	}
);