define([
	'Global',
	'App',
	'Modules',
	'MhpUser',
	'Patient',
	'secondaryHeaderView',
	'VitalSignsTableView',
	'GraphView',
	'VitalSignsGraphData',
	'Text!../../modules/html/templates/lists/standardFolder.html',
	'Text!../../modules/html/templates/lists/collapsibleFolder.html',
	'Text!../../modules/html/templates/lists/collapsibleListItem.html'
],
	function(Global, App, Modules, MhpUser, Patient, SecondaryHeaderView, VitalSignsTableView, GraphView, VitalSignsGraph, standardFolder, collapsibleFolder, collapsibleList){
		var standardFolderTemplate = _.template(standardFolder),
			collapsibleFolderTemplate = _.template(collapsibleFolder),
			collapsibleList = _.template(collapsibleList),
			addVitalSigns = function(sectionContainer, container) {
				var graphListData = {
						"BP": "?section=BP",
						"Pulse": "?section=pulse",
						"Respiration": "?section=respiration",
						"Temperature": "?section=temperature",
						"Weight": "?section=weight",
						"Pain": "?section=pain",
						"Pulse Ox": "?section=pulse-ox"
					},
					user = Patient.instance(),
					tableDataLink = user.get(App.defineResourceTitles().vitalsTableDataTitle).href,
					graphDataURL = user.get(App.defineResourceTitles().vitalsGraphDataTitle).href;
				container.append(standardFolderTemplate({folderTitle: 'Table', eventType: 'show-table', eventLink: tableDataLink }));
				container.append(collapsibleFolderTemplate({folderTitle: 'Graphical', listTitle: 'graph-results' }));

				$.each(graphListData, function(graphListItemTitle, graphListQuery){
					var link = graphDataURL + graphListQuery;
					container.find('[id = "graph-results"]').append(collapsibleList({header: graphListItemTitle, clickHandler: "graph-link", noteLink: link}));
				});
				sectionContainer.empty().append(container).trigger('create');
			};

		var SectionListView = Backbone.View.extend({
			tagName: 'div',
			id: 'vital-signs-list',
			attributes: {'data-role': 'listview', 'data-divider-theme': 'b'},
			initialize: function(){
			},
			render: function(){
				var container = this.$el,
					actions = {title: Modules.getConstants().VITAL_SIGNS_TAB},
					sectionContainer = $('#content-secondary .scrollable'),
					primaryContainer = $('#content-primary .scrollable'),
					secondaryHeaderView = new SecondaryHeaderView();

				$(document).jqmData('searchTerm', undefined);
				sectionContainer.empty();
				primaryContainer.empty();
				container.empty();

				secondaryHeaderView.render(actions);

				var user = Patient.instance();
				if (user.isValid()) {
					addVitalSigns(sectionContainer, container);
				} else {
					user.fetch({
						url: MhpUser.instance().get('patient').href,
						async: false,
						success: function(response) {
							Global.getUtilities().flattenLinks(response);
							addVitalSigns(sectionContainer, container);
						}
					});
				}

				this.detailsPage = new GraphView(VitalSignsGraph);

				return sectionContainer;

			},
			events: {
				"tap a.event-button": "tapVitalsItem"
			},
			tapVitalsItem: function(e){
				e.preventDefault();
				var eventType = $(e.currentTarget).attr('data-type'),
					eventLink = $(e.currentTarget).attr('data-url'),
					primaryView = $('#content-primary .scrollable'),
					itemParent = $(e.currentTarget).parents('li');

				itemParent.parents('#vital-signs-list').find('li.ui-btn-active').removeClass('ui-btn-active');
				itemParent.toggleClass('ui-btn-active');
				var VitalSignsGraph = this.VitalSignsGraph,
					detailsPage;
				switch(eventType){
					case "show-table":
						detailsPage = new VitalSignsTableView();
						primaryView.empty().append(detailsPage.render(eventLink));
						break;
					case "graph-link":
						$(document).jqmRemoveData('searchTerm');
						$(document).jqmData('graphURL', eventLink);
						this.detailsPage.render();
						this.detailsPage.renderGraph();
						break;
				}

				Global.getUtilities().slidePrimary();

			}
		});
		return SectionListView;
	}
);