define([
	'Global',
	'App',
	'Modules',
	'MhpUser',
	'Patient',
	'secondaryHeaderView',
	'PatientDetailsView',
	'Text!../../modules/html/templates/lists/listItem.html'
	],
	function(Global, App, Modules, MhpUser, Patient, SecondaryHeaderView, PatientDetailsView, listItem) {
		var SectionListView = Backbone.View.extend({
			tagName: 'ul',
			id: 'section-list',
			attributes: {"data-role": 'listview', "data-divider-theme": 'b', 'class': 'ui-selectmenu-list ui-disabled' },
			initialize: function() {
				this.template = _.template(listItem),
				this.patient = Patient.instance();
			},
			render: function() {
				var patient = this.patient,
					secondaryHeaderView = new SecondaryHeaderView(),
					scope = this;
				$('#content-primary .scrollable').empty()
				$.mobile.loading('show');
				var actions = {title: Modules.getConstants().SECTION_LIST_TITLE};

				if (patient.isValid()) {
					this.loadPatientDetails();
				} else {
					patient.fetch({
						url: MhpUser.instance().get('patient').href,
						success: function(response) {
							Global.getUtilities().flattenLinks(response);
							scope.loadPatientDetails();
						}
					});
				}
				secondaryHeaderView.render(actions);
				this.delegateEvents();
			},
			events: {
				"tap .section-list-item": "scrollToModule"
			},

			scrollToModule: function(e) {
				e.preventDefault();
				var target = $(e.currentTarget).data('target');
				Modules.getUtilities().addPosition();
				Global.getUtilities().slidePrimary();
				$('#content-primary .scrollable').stop().animate({
					scrollTop: $('#' + target).data('offset') - 50
				},'500', function(){});
			},

			loadPatientDetails: function() {
				var items = [],
					template = this.template,
					summaryItems = App.assembleSummaryItems(),
					length = summaryItems.length,
					$sectionContainer = $('#content-secondary .scrollable').empty(),
					$container = $(this.el).empty();

				for (var i=0; i < length; i++) {
					items.push(template(summaryItems[i]));
				}

				$container.append(items.join(''));

				$sectionContainer.empty().append(this.$el).trigger('create');

				new PatientDetailsView().render();
				$container.removeClass('ui-disabled');

			}
		});
		return SectionListView;
	}
);
